/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataStoreBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;

public class DataStoreBO
implements IDataStoreBO {
    private IDAOFactory daoFactory;
    private Session session;
    private IDataStoreServiceFactory dssFactory;
    private DataStorePE dataStore;

    public DataStoreBO(IDAOFactory daoFactory, Session session, IDataStoreServiceFactory dssFactory) {
        this.daoFactory = daoFactory;
        this.session = session;
        this.dssFactory = dssFactory;
    }

    @Override
    public void loadByCode(String dssCode) {
        this.dataStore = this.daoFactory.getDataStoreDAO().tryToFindDataStoreByCode(dssCode);
    }

    @Override
    public void uploadFile(String dropboxName, CustomImportFile customImportFile) {
        assert (this.dataStore != null) : "data store not loaded.";
        IDataStoreService service = this.dssFactory.create(this.dataStore.getRemoteUrl());
        service.putDataSet(this.session.getSessionToken(), dropboxName, customImportFile);
    }
}

