/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractMaterialBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.material.IMaterialId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.material.MaterialCodeAndTypeCodeId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.material.MaterialTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public final class MaterialBO
extends AbstractMaterialBusinessObject
implements IMaterialBO {
    private MaterialPE material;
    private boolean dataChanged;

    public MaterialBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Override
    public MaterialPE tryFindByMaterialId(IMaterialId materialId) {
        if (materialId == null) {
            throw new IllegalArgumentException("Material id cannot be null");
        }
        if (materialId instanceof MaterialCodeAndTypeCodeId) {
            MaterialCodeAndTypeCodeId codeAndTypeCodeId = (MaterialCodeAndTypeCodeId)materialId;
            MaterialIdentifier identifier = new MaterialIdentifier(codeAndTypeCodeId.getCode(), codeAndTypeCodeId.getTypeCode());
            return this.getMaterialDAO().tryFindMaterial(identifier);
        }
        if (materialId instanceof MaterialTechIdId) {
            MaterialTechIdId techIdId = (MaterialTechIdId)materialId;
            return (MaterialPE)this.getMaterialDAO().tryGetByTechId(new TechId(techIdId.getTechId()), new String[0]);
        }
        throw new IllegalArgumentException("Unsupported material id: " + materialId);
    }

    @Override
    public void loadDataByTechId(TechId materialId) {
        this.material = this.getMaterialById(materialId);
        this.dataChanged = false;
        HibernateUtils.initialize(this.material.getMaterialType().getMaterialTypePropertyTypes());
    }

    @Override
    public void loadByMaterialIdentifier(MaterialIdentifier identifier) {
        this.material = this.getMaterialDAO().tryFindMaterial(identifier);
        if (this.material == null) {
            throw new UserFailureException(String.format("Material with identifier '%s' does not exist.", identifier));
        }
        this.dataChanged = false;
    }

    @Override
    public final void enrichWithProperties() {
        if (this.material != null) {
            HibernateUtils.initialize(this.material.getProperties());
        }
    }

    @Override
    public void save() throws UserFailureException {
        assert (this.dataChanged) : "Data not changed";
        try {
            this.getMaterialDAO().createOrUpdateMaterials(Collections.singletonList(this.material));
        }
        catch (DataAccessException ex) {
            MaterialBO.throwException(ex, String.format("Material '%s'", this.material.getCode()));
        }
        this.checkBusinessRules();
        this.dataChanged = false;
    }

    private void checkBusinessRules() {
        this.entityPropertiesConverter.checkMandatoryProperties(this.material.getProperties(), this.material.getMaterialType());
    }

    @Override
    public void update(MaterialUpdateDTO materialUpdate) {
        this.loadDataByTechId(materialUpdate.getMaterialId());
        if (!materialUpdate.getVersion().equals(this.material.getModificationDate())) {
            MaterialBO.throwModifiedEntityException("Material");
        }
        this.setMetaprojects(this.material, materialUpdate.getMetaprojectsOrNull());
        this.updateProperties(materialUpdate.getProperties());
        this.dataChanged = true;
    }

    private void updateProperties(List<IEntityProperty> properties) {
        Set<MaterialPropertyPE> existingProperties = this.material.getProperties();
        MaterialTypePE type = this.material.getMaterialType();
        this.material.setProperties(this.convertProperties(type, existingProperties, properties, this.extractPropertiesCodes(properties)));
    }

    @Override
    public MaterialPE getMaterial() {
        return this.material;
    }

    @Override
    public void deleteByTechId(TechId materialId, String reason) {
        this.loadDataByTechId(materialId);
        try {
            this.getMaterialDAO().delete(this.material);
            this.getEventDAO().persist(MaterialBO.createDeletionEvent(this.material, this.session.tryGetPerson(), reason));
        }
        catch (DataAccessException ex) {
            MaterialBO.throwException(ex, this.material.getPermId(), EntityKind.MATERIAL);
        }
    }

    public static EventPE createDeletionEvent(MaterialPE material, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.MATERIAL);
        event.setIdentifiers(Collections.singletonList(material.getCode()));
        event.setDescription(material.getPermId());
        event.setReason(reason);
        event.setRegistrator(registrator);
        return event;
    }

    @Override
    public void updateManagedProperty(IManagedProperty managedProperty) {
        Set<MaterialPropertyPE> existingProperties = this.material.getProperties();
        MaterialTypePE type = this.material.getMaterialType();
        PersonPE registrator = this.findPerson();
        this.material.setProperties(this.entityPropertiesConverter.updateManagedProperty(existingProperties, type, managedProperty, registrator));
        this.dataChanged = true;
    }
}

