/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.common;

import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;

public abstract class AbstractBatchIterator<T>
implements Iterable<T> {
    private final LongSet items;
    protected final int chunkSize;

    protected abstract Iterable<T> createUnefficientIterator(LongSet var1);

    protected AbstractBatchIterator(LongSet items, int chunkSize) {
        this.chunkSize = chunkSize;
        this.items = items;
    }

    @Override
    public Iterator<T> iterator() {
        LongIterator unprocessedItems = this.items.iterator();
        return new Iterator<T>((Iterator)unprocessedItems){
            private Iterator<T> fetchedResults = null;
            private final /* synthetic */ Iterator val$unprocessedItems;
            {
                this.val$unprocessedItems = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.fetchNextPortionIfNeeded();
            }

            @Override
            public T next() {
                this.fetchNextPortionIfNeeded();
                return this.fetchedResults.next();
            }

            private boolean fetchNextPortionIfNeeded() {
                while (true) {
                    boolean fetchedHasNext;
                    boolean bl = fetchedHasNext = this.fetchedResults != null && this.fetchedResults.hasNext();
                    if (fetchedHasNext || !this.val$unprocessedItems.hasNext()) {
                        return fetchedHasNext;
                    }
                    if (!($assertionsDisabled || !fetchedHasNext && this.val$unprocessedItems.hasNext())) {
                        throw new AssertionError();
                    }
                    LongOpenHashSet nextPortion = new LongOpenHashSet();
                    while (this.val$unprocessedItems.hasNext() && nextPortion.size() < AbstractBatchIterator.this.chunkSize) {
                        Long next = (Long)this.val$unprocessedItems.next();
                        nextPortion.add((Object)next);
                    }
                    this.fetchedResults = AbstractBatchIterator.this.createUnefficientIterator((LongSet)nextPortion).iterator();
                }
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }
}

