/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.coreplugin;

import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.coreplugin.CorePluginsInjectingPropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JettyWebAppPluginInjector {
    private static final String WEBAPP_FOLDER = "webapp";
    private static final String START_PAGE = "start-page";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, JettyWebAppPluginInjector.class);
    private final List<String> webapps;
    private final Map<String, Properties> webappProperties;
    public static final String WEB_APP_FOLDER_PROPERTY = "webapp-folder";
    private Map<String, File> webappToFoldersMap;

    private static Map<String, Properties> extractWebappProperties(Properties props, List<String> webapps) {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (String webapp : webapps) {
            Properties webappProperties = PropertyParametersUtil.extractSingleSectionProperties(props, webapp, false).getProperties();
            map.put(webapp, webappProperties);
        }
        return map;
    }

    public JettyWebAppPluginInjector(Properties props) {
        List<String> appList = PropertyUtils.tryGetListInOriginalCase(props, "webapps");
        this.webapps = appList == null ? Collections.emptyList() : appList;
        this.webappProperties = JettyWebAppPluginInjector.extractWebappProperties(props, this.webapps);
        this.webappToFoldersMap = new HashMap<String, File>();
        String corePluginsFolder = CorePluginsUtils.getCorePluginsFolder(props, CorePluginScanner.ScannerType.AS);
        CorePluginScanner scanner = new CorePluginScanner(corePluginsFolder, CorePluginScanner.ScannerType.AS);
        List<CorePlugin> plugins = scanner.scanForPlugins();
        block0: for (CorePlugin plugin : plugins) {
            File[] pluginFolders;
            File webappsFolder = new File(corePluginsFolder, CorePluginScanner.constructPath(plugin, CorePluginScanner.ScannerType.AS, CorePluginsInjectingPropertyPlaceholderConfigurer.PLUGIN_TYPE_WEBAPPS));
            if (!webappsFolder.isDirectory()) continue;
            File[] fileArray = pluginFolders = webappsFolder.listFiles();
            int n = pluginFolders.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                String webappName = folder.getName();
                if (!webappName.startsWith(".")) {
                    Properties webappProps = this.webappProperties.get(webappName);
                    if (webappProps == null) continue block0;
                    String f = webappProps.getProperty(WEB_APP_FOLDER_PROPERTY);
                    this.webappToFoldersMap.put(webappName, new File(f));
                }
                ++n2;
            }
        }
    }

    public void injectWebApps() {
        List<String> remainingWebapps = this.replaceDefaultStartPageByWebApp();
        if (remainingWebapps.isEmpty()) {
            return;
        }
        operationLog.info("Inject the following web apps: " + remainingWebapps);
        List<File> targets = this.findInjectionTargets();
        for (String webapp : remainingWebapps) {
            File folder = this.webappToFoldersMap.get(webapp);
            if (folder == null) continue;
            String path = folder.getAbsolutePath();
            for (File target : targets) {
                File webappFolder = new File(target, WEBAPP_FOLDER);
                webappFolder.mkdirs();
                File link = new File(webappFolder, webapp);
                if (link.exists()) continue;
                String linkPath = link.getAbsolutePath();
                Unix.createSymbolicLink(path, linkPath);
                operationLog.info("WebApp '" + webapp + "': Symbolic link " + linkPath + " -> " + path);
            }
        }
    }

    private List<String> replaceDefaultStartPageByWebApp() {
        ArrayList<String> remainingWebApps = new ArrayList<String>(this.webapps);
        if (!remainingWebApps.contains(START_PAGE)) {
            return remainingWebApps;
        }
        remainingWebApps.remove(START_PAGE);
        operationLog.info("Replace default start page by web app 'start-page'.");
        File webappFolder = this.webappToFoldersMap.get(START_PAGE);
        if (webappFolder != null) {
            for (File target : this.findInjectionTargets()) {
                target.mkdirs();
                File folderCustom = new File(target, "custom");
                if (folderCustom.exists()) {
                    boolean success = FileUtilities.deleteRecursively(folderCustom);
                    if (success) {
                        operationLog.info(folderCustom.getAbsoluteFile() + " deleted.");
                    } else {
                        operationLog.error("Couldn't delete folder " + folderCustom.getAbsolutePath() + ".");
                    }
                }
                Unix.createSymbolicLink(webappFolder.getAbsolutePath(), folderCustom.getAbsolutePath());
                operationLog.info("Symbolic link: " + folderCustom.getAbsolutePath() + " -> " + webappFolder.getAbsolutePath());
                File webappIndexFile = new File(webappFolder, "index.html");
                if (!webappIndexFile.exists()) continue;
                File indexFile = new File(target, "index.html");
                if (indexFile.exists()) {
                    boolean success = FileUtilities.delete(indexFile);
                    if (success) {
                        operationLog.info(String.valueOf(indexFile.getAbsolutePath()) + " deleted.");
                    } else {
                        operationLog.error("Couldn't delete file " + indexFile.getAbsolutePath() + ".");
                    }
                }
                Unix.createSymbolicLink(webappIndexFile.getAbsolutePath(), indexFile.getAbsolutePath());
                operationLog.info("Symbolic link: " + indexFile.getAbsolutePath() + " -> " + webappIndexFile.getAbsolutePath());
            }
        }
        return remainingWebApps;
    }

    private List<File> findInjectionTargets() {
        ArrayList<File> list = new ArrayList<File>();
        String jettyHome = System.getProperty("jetty.home");
        if (jettyHome != null) {
            list.add(new File(String.valueOf(jettyHome) + "/webapps/openbis/"));
        } else {
            File[] files;
            File[] fileArray = files = new File("targets/www").listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.getName().equals("WEB-INF")) {
                    list.add(file);
                }
                ++n2;
            }
        }
        return list;
    }
}

