/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DynamicPropertyEvaluationOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final Set<Long> ids;

    public static DynamicPropertyEvaluationOperation evaluate(Class<? extends IEntityInformationWithPropertiesHolder> clazz, Collection<Long> ids) {
        return new DynamicPropertyEvaluationOperation(clazz, ids);
    }

    public static DynamicPropertyEvaluationOperation evaluateAll(Class<? extends IEntityInformationWithPropertiesHolder> clazz) {
        return new DynamicPropertyEvaluationOperation(clazz, null);
    }

    private DynamicPropertyEvaluationOperation(Class<? extends IEntityInformationWithPropertiesHolder> clazz, Collection<Long> ids) {
        this.className = clazz.getName();
        if (ids == null) {
            this.ids = null;
        } else {
            this.ids = new HashSet<Long>();
            this.ids.addAll(ids);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Set<Long> getIds() {
        return this.ids;
    }

    public String toString() {
        return String.valueOf(this.className) + ": " + (this.ids == null ? "all" : CollectionUtils.abbreviate(this.ids, 10));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.ids == null ? 0 : this.ids.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicPropertyEvaluationOperation other = (DynamicPropertyEvaluationOperation)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.ids == null ? other.ids != null : !this.ids.equals(other.ids));
    }
}

