/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyPlaceholderCreator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyValueValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PlaceholderPropertyCreator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PropertyValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.KeyExtractorFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IPerson;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IManagedPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;

public final class EntityPropertiesConverter
implements IEntityPropertiesConverter {
    private static final IKeyExtractor<PropertyTypePE, ExtendedEntityTypePropertyType> EXTENDED_ETPT_KEY_EXTRACTOR = new IKeyExtractor<PropertyTypePE, ExtendedEntityTypePropertyType>(){

        @Override
        public PropertyTypePE getKey(ExtendedEntityTypePropertyType etpt) {
            return etpt.getEntityTypePropertyTypePE().getPropertyType();
        }
    };
    private static final String NO_ENTITY_PROPERTY_VALUE_FOR_S = "Value of mandatory property '%s' not specified.";
    private final IDAOFactory daoFactory;
    private final EntityKind entityKind;
    private TableMap<String, EntityTypePE> entityTypesByCode;
    private Map<String, Set<String>> dynamicPropertiesByEntityTypeCode = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> managedPropertiesByEntityTypeCode = new HashMap<String, Set<String>>();
    private final TableMap<String, PropertyTypePE> propertyTypesByCode = new TableMap<String, PropertyTypePE>(KeyExtractorFactory.getPropertyTypeByCodeKeyExtractor());
    private Map<String, TableMap<PropertyTypePE, ExtendedEntityTypePropertyType>> entityTypePropertyTypesByEntityTypeAndPropertyType = new HashMap<String, TableMap<PropertyTypePE, ExtendedEntityTypePropertyType>>();
    private final ComplexPropertyValueHelper complexPropertyValueHelper;
    private final IPropertyValueValidator propertyValueValidator;
    private final IPropertyPlaceholderCreator placeholderCreator;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public EntityPropertiesConverter(EntityKind entityKind, IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this(entityKind, daoFactory, new PropertyValidator(), new PlaceholderPropertyCreator(), managedPropertyEvaluatorFactory);
    }

    @Private
    EntityPropertiesConverter(EntityKind entityKind, IDAOFactory daoFactory, IPropertyValueValidator propertyValueValidator, IPropertyPlaceholderCreator placeholderCreator, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        assert (entityKind != null) : "Unspecified entity kind.";
        assert (daoFactory != null) : "Unspecified DAO factory.";
        assert (propertyValueValidator != null) : "Unspecified property value validator.";
        this.daoFactory = daoFactory;
        this.entityKind = entityKind;
        this.propertyValueValidator = propertyValueValidator;
        this.placeholderCreator = placeholderCreator;
        this.complexPropertyValueHelper = new ComplexPropertyValueHelper(daoFactory, null);
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    private final Set<String> getDynamicProperties(EntityTypePE entityTypePE) {
        String code = entityTypePE.getCode();
        if (!this.dynamicPropertiesByEntityTypeCode.containsKey(code)) {
            HashSet<String> set = new HashSet<String>();
            List<EntityTypePropertyTypePE> list = this.daoFactory.getEntityPropertyTypeDAO(this.entityKind).listEntityPropertyTypes(entityTypePE);
            for (EntityTypePropertyTypePE etpt : list) {
                if (!etpt.isDynamic()) continue;
                set.add(etpt.getPropertyType().getCode());
            }
            this.dynamicPropertiesByEntityTypeCode.put(code, set);
        }
        return this.dynamicPropertiesByEntityTypeCode.get(code);
    }

    private final Set<String> getManagedProperties(EntityTypePE entityTypePE) {
        String code = entityTypePE.getCode();
        if (!this.managedPropertiesByEntityTypeCode.containsKey(code)) {
            HashSet<String> set = new HashSet<String>();
            List<EntityTypePropertyTypePE> list = this.daoFactory.getEntityPropertyTypeDAO(this.entityKind).listEntityPropertyTypes(entityTypePE);
            for (EntityTypePropertyTypePE etpt : list) {
                if (!etpt.isManaged()) continue;
                set.add(etpt.getPropertyType().getCode());
            }
            this.managedPropertiesByEntityTypeCode.put(code, set);
        }
        return this.managedPropertiesByEntityTypeCode.get(code);
    }

    private final EntityTypePE getEntityType(String entityTypeCode) {
        EntityTypePE entityType;
        if (this.entityTypesByCode == null) {
            this.entityTypesByCode = new TableMap<String, EntityTypePE>(this.daoFactory.getEntityTypeDAO(this.entityKind).listEntityTypes(), KeyExtractorFactory.getEntityTypeByCodeKeyExtractor());
        }
        if ((entityType = this.entityTypesByCode.tryGet(entityTypeCode.toUpperCase())) == null) {
            throw UserFailureException.fromTemplate("Entity type with code '%s' does not exist!", entityTypeCode);
        }
        return entityType;
    }

    private final PropertyTypePE getPropertyType(String propertyCode) {
        PropertyTypePE propertyType = this.propertyTypesByCode.tryGet(propertyCode.toUpperCase());
        if (propertyType == null) {
            propertyType = this.daoFactory.getPropertyTypeDAO().tryFindPropertyTypeByCode(propertyCode);
            if (propertyType == null) {
                throw UserFailureException.fromTemplate("Property type with code '%s' does not exist!", propertyCode);
            }
            this.propertyTypesByCode.add(propertyType);
        }
        return propertyType;
    }

    private final ExtendedEntityTypePropertyType getEntityTypePropertyType(EntityTypePE entityTypePE, PropertyTypePE propertyType) {
        ExtendedEntityTypePropertyType entityTypePropertyType;
        String entityTypeCode = entityTypePE.getCode();
        TableMap<PropertyTypePE, ExtendedEntityTypePropertyType> map = this.entityTypePropertyTypesByEntityTypeAndPropertyType.get(entityTypeCode);
        if (map == null) {
            List<ExtendedEntityTypePropertyType> entityTypePropertyTypes = this.getEntityTypePropertyTypes(entityTypePE);
            map = new TableMap<PropertyTypePE, ExtendedEntityTypePropertyType>(entityTypePropertyTypes, EXTENDED_ETPT_KEY_EXTRACTOR, TableMap.UniqueKeyViolationStrategy.KEEP_FIRST);
            this.entityTypePropertyTypesByEntityTypeAndPropertyType.put(entityTypeCode, map);
        }
        if ((entityTypePropertyType = map.tryGet(propertyType)) == null) {
            throw UserFailureException.fromTemplate("No assigment between property type '%s' and entity type '%s' could be found.", propertyType.getCode(), entityTypeCode);
        }
        return entityTypePropertyType;
    }

    private List<ExtendedEntityTypePropertyType> getEntityTypePropertyTypes(EntityTypePE entityTypePE) {
        IEntityPropertyTypeDAO entityPropertyTypeDAO = this.daoFactory.getEntityPropertyTypeDAO(this.entityKind);
        List<EntityTypePropertyTypePE> entityPropertyTypes = entityPropertyTypeDAO.listEntityPropertyTypes(entityTypePE);
        ArrayList<ExtendedEntityTypePropertyType> result = new ArrayList<ExtendedEntityTypePropertyType>();
        for (EntityTypePropertyTypePE entityTypePropertyTypePE : entityPropertyTypes) {
            result.add(new ExtendedEntityTypePropertyType(entityTypePropertyTypePE, this.managedPropertyEvaluatorFactory));
        }
        return result;
    }

    private final <T extends EntityPropertyPE> T tryConvertProperty(PersonPE registrator, EntityTypePE entityTypePE, IEntityProperty property) {
        String propertyCode = property.getPropertyType().getCode();
        PropertyTypePE propertyType = this.getPropertyType(propertyCode);
        String valueOrNull = property.tryGetAsString();
        ExtendedEntityTypePropertyType extendedETPT = this.getEntityTypePropertyType(entityTypePE, propertyType);
        EntityTypePropertyTypePE entityTypePropertyTypePE = extendedETPT.getEntityTypePropertyTypePE();
        if (entityTypePropertyTypePE.isMandatory() && EntityPropertiesConverter.isNullOrBlank(valueOrNull)) {
            throw UserFailureException.fromTemplate(NO_ENTITY_PROPERTY_VALUE_FOR_S, propertyCode);
        }
        if (!EntityPropertiesConverter.isNullOrBlank(valueOrNull)) {
            String translatedValue = extendedETPT.translate(registrator, valueOrNull);
            String validatedValue = this.propertyValueValidator.validatePropertyValue(propertyType, translatedValue);
            return this.createEntityProperty(registrator, propertyType, entityTypePropertyTypePE, validatedValue);
        }
        return null;
    }

    private final <T extends EntityPropertyPE> T createEntityProperty(PersonPE registrator, PropertyTypePE propertyType, EntityTypePropertyTypePE entityTypePropertyType, String value) {
        EntityTypePropertyTypePE entityProperty = EntityPropertyPE.createEntityProperty(this.entityKind);
        entityProperty.setRegistrator(registrator);
        ((EntityPropertyPE)((Object)entityProperty)).setAuthor(registrator);
        ((EntityPropertyPE)((Object)entityProperty)).setEntityTypePropertyType((EntityTypePropertyTypePE)entityTypePropertyType);
        this.setPropertyValue(entityProperty, propertyType, value);
        return (T)entityProperty;
    }

    @Override
    public final <T extends EntityPropertyPE> List<T> convertProperties(IEntityProperty[] properties, String entityTypeCode, PersonPE registrator) {
        return this.convertProperties(properties, entityTypeCode, registrator, true, true);
    }

    private final <T extends EntityPropertyPE> List<T> convertProperties(IEntityProperty[] properties, String entityTypeCode, PersonPE registrator, boolean createManagedPropertiesPlaceholders, boolean createDynamicPropertiesPlaceholders) {
        assert (entityTypeCode != null) : "Unspecified entity type code.";
        assert (registrator != null) : "Unspecified registrator";
        assert (properties != null) : "Unspecified entity properties";
        EntityTypePE entityTypePE = this.getEntityType(entityTypeCode);
        Set<String> dynamicProperties = this.getDynamicProperties(entityTypePE);
        Set<String> managedProperties = this.getManagedProperties(entityTypePE);
        LinkedHashSet<IEntityProperty> definedProperties = new LinkedHashSet<IEntityProperty>(Arrays.asList(properties));
        if (createDynamicPropertiesPlaceholders) {
            this.placeholderCreator.addDynamicPropertiesPlaceholders(definedProperties, dynamicProperties);
        }
        if (createManagedPropertiesPlaceholders) {
            this.placeholderCreator.addManagedPropertiesPlaceholders(definedProperties, managedProperties);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (IEntityProperty property : definedProperties) {
            T convertedPropertyOrNull = this.tryConvertProperty(registrator, entityTypePE, property);
            if (convertedPropertyOrNull == null) continue;
            list.add(convertedPropertyOrNull);
        }
        return list;
    }

    @Override
    public <T extends EntityPropertyPE> void checkMandatoryProperties(Collection<T> properties, EntityTypePE entityTypePE) {
        assert (properties != null);
        this.checkMandatoryProperties(properties, entityTypePE, this.daoFactory.getEntityPropertyTypeDAO(this.entityKind).listEntityPropertyTypes(entityTypePE));
    }

    @Override
    public <T extends EntityPropertyPE> void checkMandatoryProperties(Collection<T> properties, EntityTypePE entityTypePE, Map<EntityTypePE, List<EntityTypePropertyTypePE>> cache) {
        assert (properties != null);
        this.checkMandatoryProperties(properties, entityTypePE, this.getAssignedPropertiesForEntityType(cache, entityTypePE));
    }

    private List<EntityTypePropertyTypePE> getAssignedPropertiesForEntityType(Map<EntityTypePE, List<EntityTypePropertyTypePE>> cache, EntityTypePE entityTypePE) {
        List<EntityTypePropertyTypePE> assignedProperties = cache.get(entityTypePE);
        if (assignedProperties == null) {
            assignedProperties = this.daoFactory.getEntityPropertyTypeDAO(this.entityKind).listEntityPropertyTypes(entityTypePE);
            cache.put(entityTypePE, assignedProperties);
        }
        return assignedProperties;
    }

    private <T extends EntityPropertyPE> void checkMandatoryProperties(Collection<T> properties, EntityTypePE entityTypePE, List<EntityTypePropertyTypePE> assignedProperties) {
        assert (properties != null);
        if (assignedProperties == null || assignedProperties.size() == 0) {
            return;
        }
        HashSet<EntityTypePropertyTypePE> definedProperties = new HashSet<EntityTypePropertyTypePE>();
        for (EntityPropertyPE p : properties) {
            definedProperties.add(p.getEntityTypePropertyType());
        }
        for (EntityTypePropertyTypePE etpt : assignedProperties) {
            if (!etpt.isMandatory() || definedProperties.contains(etpt)) continue;
            throw UserFailureException.fromTemplate(NO_ENTITY_PROPERTY_VALUE_FOR_S, etpt.getPropertyType().getCode());
        }
    }

    @Override
    public final String tryCreateValidatedPropertyValue(PropertyTypePE propertyType, EntityTypePropertyTypePE entityTypPropertyType, String value) {
        if (entityTypPropertyType.isMandatory() && EntityPropertiesConverter.isNullOrBlank(value)) {
            throw UserFailureException.fromTemplate(NO_ENTITY_PROPERTY_VALUE_FOR_S, propertyType.getCode());
        }
        if (!EntityPropertiesConverter.isNullOrBlank(value)) {
            String validated = this.propertyValueValidator.validatePropertyValue(propertyType, value);
            return validated;
        }
        return null;
    }

    @Override
    public final <T extends EntityPropertyPE> T createValidatedProperty(PropertyTypePE propertyType, EntityTypePropertyTypePE entityTypPropertyType, PersonPE registrator, String validatedValue) {
        assert (validatedValue != null);
        return this.createEntityProperty(registrator, propertyType, entityTypPropertyType, validatedValue);
    }

    @Override
    public final <T extends EntityPropertyPE> void setPropertyValue(T entityProperty, PropertyTypePE propertyType, String validatedValue) {
        assert (validatedValue != null);
        if (validatedValue.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
            entityProperty.setUntypedValue(validatedValue, null, null);
        } else {
            VocabularyTermPE vocabularyTerm = this.complexPropertyValueHelper.tryGetVocabularyTerm(validatedValue, propertyType);
            MaterialPE material = this.complexPropertyValueHelper.tryGetMaterial(validatedValue, propertyType);
            entityProperty.setUntypedValue(validatedValue, vocabularyTerm, material);
        }
    }

    @Override
    public <T extends EntityPropertyPE> Set<T> updateProperties(Collection<T> oldProperties, EntityTypePE entityType, List<IEntityProperty> newProperties, PersonPE author) {
        HashMap<EntityPropertyPE, String> existingPropertyValues = new HashMap<EntityPropertyPE, String>();
        for (EntityPropertyPE existingProperty : oldProperties) {
            existingPropertyValues.put(existingProperty, existingProperty.tryGetUntypedValue());
        }
        List<T> convertedProperties = this.convertPropertiesForUpdate(newProperties, entityType.getCode(), author);
        HashSet<Object> set = new HashSet<Object>();
        for (EntityPropertyPE newProperty : convertedProperties) {
            PropertyTypePE propertyType = newProperty.getEntityTypePropertyType().getPropertyType();
            T existingProperty = EntityPropertiesConverter.tryFind(oldProperties, propertyType);
            if (existingProperty != null) {
                ((EntityPropertyPE)existingProperty).setUntypedValue(newProperty.getValue(), newProperty.getVocabularyTerm(), newProperty.getMaterialValue());
                if (!((String)existingPropertyValues.get(existingProperty)).equals(newProperty.tryGetUntypedValue())) {
                    ((EntityPropertyPE)existingProperty).setAuthor(author);
                }
                set.add(existingProperty);
                continue;
            }
            set.add(newProperty);
        }
        return set;
    }

    @Override
    public <T extends EntityPropertyPE> Set<T> updateManagedProperty(Collection<T> oldProperties, EntityTypePE entityType, IManagedProperty managedProperty, PersonPE author) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(oldProperties);
        T existingProperty = EntityPropertiesConverter.tryFind(oldProperties, managedProperty.getPropertyTypeCode());
        if (existingProperty != null) {
            ((EntityPropertyPE)existingProperty).setUntypedValue(managedProperty.getValue(), null, null);
            ((EntityPropertyPE)existingProperty).setAuthor(author);
        }
        return set;
    }

    private final <T extends EntityPropertyPE> List<T> convertPropertiesForUpdate(List<? extends IEntityProperty> properties, String entityTypeCode, PersonPE registrator) {
        IEntityProperty[] propsArray = properties.toArray(new IEntityProperty[0]);
        return this.convertProperties(propsArray, entityTypeCode, registrator, false, false);
    }

    @Override
    public <T extends EntityPropertyPE> Set<T> updateProperties(Collection<T> oldProperties, EntityTypePE entityType, List<IEntityProperty> newProperties, PersonPE author, Set<String> propertiesToUpdate) {
        Set<T> set = this.updateProperties(oldProperties, entityType, newProperties, author);
        for (EntityPropertyPE oldProperty : oldProperties) {
            String oldPropertyCode = oldProperty.getEntityTypePropertyType().getPropertyType().getCode();
            if (propertiesToUpdate.contains(oldPropertyCode.toLowerCase()) || propertiesToUpdate.contains(oldPropertyCode)) continue;
            set.add(oldProperty);
        }
        return set;
    }

    private static <T extends EntityPropertyPE> T tryFind(Collection<T> oldProperties, PropertyTypePE propertyType) {
        for (EntityPropertyPE oldProperty : oldProperties) {
            if (!oldProperty.getEntityTypePropertyType().getPropertyType().equals(propertyType)) continue;
            return (T)oldProperty;
        }
        return null;
    }

    private static <T extends EntityPropertyPE> T tryFind(Collection<T> oldProperties, String propertyTypeCode) {
        for (EntityPropertyPE oldProperty : oldProperties) {
            if (!oldProperty.getEntityTypePropertyType().getPropertyType().getCode().equals(propertyTypeCode)) continue;
            return (T)oldProperty;
        }
        return null;
    }

    private static boolean isNullOrBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static final class ComplexPropertyValueHelper {
        private final IDAOFactory daoFactory;
        private final IHibernateSessionProvider customSessionProviderOrNull;

        public ComplexPropertyValueHelper(IDAOFactory daoFactory, IHibernateSessionProvider customSessionProviderOrNull) {
            this.daoFactory = daoFactory;
            this.customSessionProviderOrNull = customSessionProviderOrNull;
        }

        public MaterialPE tryGetMaterial(String value, PropertyTypePE propertyType) {
            if (propertyType.getType().getCode() != DataTypeCode.MATERIAL) {
                return null;
            }
            MaterialIdentifier materialIdentifier = MaterialIdentifier.tryCreate(value, propertyType.getMaterialType());
            if (materialIdentifier == null) {
                return null;
            }
            MaterialPE material = this.customSessionProviderOrNull != null ? this.daoFactory.getMaterialDAO().tryFindMaterial(this.customSessionProviderOrNull.getSession(), materialIdentifier) : this.daoFactory.getMaterialDAO().tryFindMaterial(materialIdentifier);
            if (material == null) {
                throw UserFailureException.fromTemplate("No material could be found for identifier '%s'.", materialIdentifier);
            }
            return material;
        }

        public VocabularyTermPE tryGetVocabularyTerm(String value, PropertyTypePE propertyType) {
            if (propertyType.getType().getCode() != DataTypeCode.CONTROLLEDVOCABULARY) {
                return null;
            }
            VocabularyPE vocabulary = propertyType.getVocabulary();
            if (vocabulary == null) {
                return null;
            }
            VocabularyTermPE term = vocabulary.tryGetVocabularyTerm(value);
            if (term != null) {
                return term;
            }
            throw UserFailureException.fromTemplate("Incorrect value '%s' for a controlled vocabulary set '%s'.", value, vocabulary.getCode());
        }
    }

    private static final class ExtendedEntityTypePropertyType {
        private final EntityTypePropertyTypePE entityTypePropertyTypePE;
        private final List<IManagedInputWidgetDescription> inputWidgetDescriptions;
        private IManagedPropertyEvaluator evaluator;

        ExtendedEntityTypePropertyType(EntityTypePropertyTypePE entityTypePropertyTypePE, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
            this.entityTypePropertyTypePE = entityTypePropertyTypePE;
            if (entityTypePropertyTypePE.isManaged()) {
                this.evaluator = managedPropertyEvaluatorFactory.createManagedPropertyEvaluator(entityTypePropertyTypePE);
                this.inputWidgetDescriptions = this.evaluator.getInputWidgetDescriptions();
            } else {
                this.inputWidgetDescriptions = Collections.emptyList();
            }
        }

        public EntityTypePropertyTypePE getEntityTypePropertyTypePE() {
            return this.entityTypePropertyTypePE;
        }

        String translate(PersonPE personPE, String propertyValue) {
            if (this.inputWidgetDescriptions.isEmpty() || propertyValue == null || propertyValue.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX) || !propertyValue.startsWith("__JSON__:")) {
                return propertyValue;
            }
            try {
                List readValue = (List)new ObjectMapper().readValue(propertyValue.substring("__JSON__:".length()), List.class);
                ManagedProperty managedProperty = new ManagedProperty();
                IPerson person = PersonTranslator.translateToIPerson(personPE);
                ArrayList<Map<String, String>> bindingsList = new ArrayList<Map<String, String>>();
                for (Object row : readValue) {
                    if (!(row instanceof Map)) continue;
                    bindingsList.add((Map)row);
                }
                this.evaluator.updateFromRegistrationForm(managedProperty, person, bindingsList);
                return managedProperty.getValue();
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    public static interface IHibernateSessionProvider {
        public Session getSession();
    }
}

