/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGenericDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public interface IDataDAO
extends IGenericDAO<DataPE> {
    public boolean hasDataSet(SamplePE var1) throws DataAccessException;

    public List<DataPE> listRelatedDataSets(List<IEntityInformationHolder> var1, EntityKind var2) throws DataAccessException;

    public List<DataPE> listDataSets(SamplePE var1) throws DataAccessException;

    public List<DataPE> listDataSetsWithoutRelationships(SamplePE var1) throws DataAccessException;

    public List<DataPE> listDataSets(ExperimentPE var1) throws DataAccessException;

    public DataPE tryToFindDataSetByCode(String var1);

    public DataPE tryToFindFullDataSetByCode(String var1, boolean var2, boolean var3);

    public List<DataPE> tryToFindFullDataSetsByIds(Collection<Long> var1, boolean var2, boolean var3);

    public List<DataPE> tryToFindFullDataSetsByCodes(Collection<String> var1, boolean var2, boolean var3);

    public List<DeletedDataPE> tryToFindDeletedDataSetsByCodes(Collection<String> var1);

    public void updateDataSetStatuses(List<String> var1, DataSetArchivingStatus var2);

    public void updateDataSetStatuses(List<String> var1, DataSetArchivingStatus var2, boolean var3);

    public void updateSizes(Map<String, Long> var1);

    public void createDataSet(DataPE var1, PersonPE var2);

    public void updateDataSet(DataPE var1, PersonPE var2);

    public List<DataPE> listExternalData(DataStorePE var1);

    public Set<TechId> findParentIds(Collection<TechId> var1);

    public List<DataPE> listByCode(Set<String> var1);

    public List<SpacePE> listSpacesByDataSetIds(Collection<Long> var1);

    public void updateDataSets(List<DataPE> var1, PersonPE var2);

    public List<TechId> listDataSetIdsBySampleIds(Collection<TechId> var1);

    public List<TechId> listDataSetIdsByExperimentIds(Collection<TechId> var1);

    public List<TechId> listContainedDataSets(Collection<TechId> var1);

    public List<TechId> listContainedDataSetsRecursively(Collection<TechId> var1);

    public void delete(List<TechId> var1, PersonPE var2, String var3) throws DataAccessException;

    public boolean confirmStorage(String var1);

    public boolean exists(String var1);

    public boolean updateAccessTimestamp(String var1);

    public boolean isAccessTimestampEnabled();

    public TechId tryToFindDataSetIdByCode(String var1);
}

