/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGenericDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public abstract class AbstractGenericEntityDAO<T extends IIdHolder>
extends AbstractDAO
implements IGenericDAO<T> {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractGenericEntityDAO.class);
    private final Class<T> entityClass;

    protected AbstractGenericEntityDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance, Class<T> entityClass) {
        super(sessionFactory, databaseInstance);
        this.entityClass = entityClass;
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public final T getByTechId(TechId techId) throws DataAccessException {
        assert (techId != null) : "Technical identifier unspecified.";
        Object entity = this.getHibernateTemplate().get(this.getEntityClass(), (Serializable)techId.getId());
        IIdHolder result = null;
        if (entity == null) {
            throw new DataRetrievalFailureException(String.valueOf(this.getEntityDescription()) + " with ID " + techId.getId() + " does not exist. Maybe someone has just deleted it.");
        }
        result = (IIdHolder)AbstractGenericEntityDAO.getEntity(entity);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), techId, result));
        }
        return (T)result;
    }

    public final T loadByTechId(TechId techId) throws DataAccessException {
        assert (techId != null) : "Technical identifier unspecified.";
        return (T)((IIdHolder)AbstractGenericEntityDAO.getEntity(this.getHibernateTemplate().load(this.getEntityClass(), (Serializable)techId.getId())));
    }

    private String getEntityDescription() {
        String nameWithoutPE = this.getEntityClass().getSimpleName().replace("PE", "");
        Object[] words = StringUtils.splitByCharacterTypeCamelCase((String)nameWithoutPE);
        return StringUtils.join((Object[])words, (String)" ");
    }

    @Override
    public final T tryGetByTechId(TechId techId, String ... connections) throws DataAccessException {
        assert (techId != null) : "Technical identifier unspecified.";
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)techId.getId()));
        String[] stringArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            String connection = stringArray[n2];
            criteria.setFetchMode(connection, FetchMode.SELECT);
            ++n2;
        }
        IIdHolder result = (IIdHolder)AbstractGenericEntityDAO.tryGetEntity(criteria.uniqueResult());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s(%s): '%s'.", MethodUtils.getCurrentMethod().getName(), techId, result));
        }
        return (T)result;
    }

    @Override
    public void validateAndSaveUpdatedEntity(T entity) throws DataAccessException {
        assert (entity != null) : "entity is null";
        AbstractGenericEntityDAO.validatePE(entity);
        AbstractGenericEntityDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
    }

    @Override
    public final void validate(T entity) {
        assert (entity != null) : "entity is null";
        AbstractGenericEntityDAO.validatePE(entity);
    }

    public void clearSession() {
        this.getHibernateTemplate().clear();
    }

    public final void flush() {
        this.getHibernateTemplate().flush();
    }

    @Override
    public void persist(T entity) {
        assert (entity != null) : "entity unspecified";
        AbstractGenericEntityDAO.validatePE(entity);
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.save(entity);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.debug(String.format("%s(%s)", MethodUtils.getCurrentMethod().getName(), entity));
        }
    }

    @Override
    public void delete(T entity) throws DataAccessException {
        assert (entity != null) : "entity unspecified";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.delete(entity);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.debug(String.format("%s(%s)", MethodUtils.getCurrentMethod().getName(), entity));
        }
    }

    @Override
    public List<T> listAllEntities() throws DataAccessException {
        return AbstractGenericEntityDAO.cast(this.getHibernateTemplate().loadAll(this.getEntityClass()));
    }
}

