/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDatabaseInstanceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomColumnDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomFilterDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IMetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IQueryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DatabaseInstanceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.GridCustomColumnDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.GridCustomFilterDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.MetaprojectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.ProjectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.QueryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.RelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.RoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdateScheduler;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.UuidUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.dao.DataAccessException;

public class AuthorizationDAOFactory
implements IAuthorizationDAOFactory {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AuthorizationDAOFactory.class);
    private final IDatabaseInstanceDAO databaseInstancesDAO;
    private final IRoleAssignmentDAO roleAssignmentDAO;
    private final ISpaceDAO groupDAO;
    private final IPersonDAO personDAO;
    private final IDataDAO dataDAO;
    private final IExperimentDAO experimentDAO;
    private final DatabaseInstancePE homeDatabaseInstance;
    private final IProjectDAO projectDAO;
    private final ISampleDAO sampleDAO;
    private final IGridCustomFilterDAO gridCustomFilterDAO;
    private final IGridCustomColumnDAO gridCustomColumnDAO;
    private final QueryDAO queryDAO;
    private final PersistencyResources persistencyResources;
    private final IRelationshipTypeDAO relationshipTypeDAO;
    private final IDeletionDAO deletionDAO;
    private final IMetaprojectDAO metaprojectDAO;

    public AuthorizationDAOFactory(DatabaseConfigurationContext context, SessionFactory sessionFactory, IFullTextIndexUpdateScheduler indexUpdateScheduler, IDynamicPropertyEvaluationScheduler dynamicPropertyEvaluationScheduler) {
        this.persistencyResources = new PersistencyResources(context, sessionFactory, indexUpdateScheduler, dynamicPropertyEvaluationScheduler);
        this.databaseInstancesDAO = new DatabaseInstanceDAO(sessionFactory);
        this.homeDatabaseInstance = this.getDatabaseInstanceId(context.getDatabaseInstance());
        this.personDAO = new PersonDAO(sessionFactory, this.homeDatabaseInstance);
        this.groupDAO = new SpaceDAO(sessionFactory, this.homeDatabaseInstance);
        this.roleAssignmentDAO = new RoleAssignmentDAO(sessionFactory, this.homeDatabaseInstance);
        this.dataDAO = new DataDAO(this.persistencyResources, this.homeDatabaseInstance);
        this.experimentDAO = new ExperimentDAO(this.persistencyResources, this.homeDatabaseInstance);
        this.projectDAO = new ProjectDAO(sessionFactory, this.homeDatabaseInstance);
        this.sampleDAO = new SampleDAO(this.persistencyResources, this.homeDatabaseInstance);
        this.gridCustomFilterDAO = new GridCustomFilterDAO(sessionFactory, this.homeDatabaseInstance);
        this.gridCustomColumnDAO = new GridCustomColumnDAO(sessionFactory, this.homeDatabaseInstance);
        this.queryDAO = new QueryDAO(sessionFactory, this.homeDatabaseInstance);
        this.relationshipTypeDAO = new RelationshipTypeDAO(sessionFactory, this.homeDatabaseInstance);
        this.deletionDAO = new DeletionDAO(sessionFactory, this.homeDatabaseInstance, this.persistencyResources);
        this.metaprojectDAO = new MetaprojectDAO(sessionFactory, this.homeDatabaseInstance);
    }

    @Override
    public final PersistencyResources getPersistencyResources() {
        return this.persistencyResources;
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.persistencyResources.getSessionFactory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DatabaseInstancePE getDatabaseInstanceId(String databaseInstanceCode) {
        assert (databaseInstanceCode != null) : "Unspecified database instance";
        try {
            DatabaseInstancePE originalSource = this.databaseInstancesDAO.getHomeInstance();
            String origCode = originalSource.getCode();
            if (originalSource.isSystemDefault()) {
                if (!StringUtils.isNotEmpty((String)databaseInstanceCode) || DatabaseInstancePE.isSystemDefault(databaseInstanceCode)) throw new ConfigurationFailureException(String.format("Invalid database instance '%s'.", databaseInstanceCode));
                this.updateDatabaseInstanceCode(originalSource, databaseInstanceCode, origCode);
                return originalSource;
            } else {
                if (!operationLog.isInfoEnabled()) return originalSource;
                operationLog.info(String.format("Original source database instance: '%s'.", origCode));
            }
            return originalSource;
        }
        catch (DataAccessException ex) {
            throw new ConfigurationFailureException("A problem has occurred while getting or setting the original source database instance.", ex);
        }
    }

    private void updateDatabaseInstanceCode(DatabaseInstancePE databaseInstancePE, String newCode, String oldCode) throws UserFailureException {
        if (UuidUtil.isValidUUID(newCode)) {
            throw UserFailureException.fromTemplate("The new database instance code '%s' has an UUID format and should not.", newCode);
        }
        String uuid = UuidUtil.generateUUID();
        databaseInstancePE.setUuid(uuid);
        databaseInstancePE.setCode(newCode);
        this.databaseInstancesDAO.updateDatabaseInstancePE(databaseInstancePE);
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("Original source database instance renamed from '%s' to '%s'. UUID = '%s'.", oldCode, newCode, uuid));
        }
    }

    @Override
    public final DatabaseInstancePE getHomeDatabaseInstance() {
        return this.homeDatabaseInstance;
    }

    @Override
    public final IDatabaseInstanceDAO getDatabaseInstanceDAO() {
        return this.databaseInstancesDAO;
    }

    @Override
    public final ISpaceDAO getSpaceDAO() {
        return this.groupDAO;
    }

    @Override
    public final IPersonDAO getPersonDAO() {
        return this.personDAO;
    }

    @Override
    public final IRoleAssignmentDAO getRoleAssignmentDAO() {
        return this.roleAssignmentDAO;
    }

    @Override
    public final IDataDAO getDataDAO() {
        return this.dataDAO;
    }

    @Override
    public final IExperimentDAO getExperimentDAO() {
        return this.experimentDAO;
    }

    @Override
    public final IProjectDAO getProjectDAO() {
        return this.projectDAO;
    }

    @Override
    public final ISampleDAO getSampleDAO() {
        return this.sampleDAO;
    }

    @Override
    public IGridCustomFilterDAO getGridCustomFilterDAO() {
        return this.gridCustomFilterDAO;
    }

    @Override
    public IGridCustomColumnDAO getGridCustomColumnDAO() {
        return this.gridCustomColumnDAO;
    }

    @Override
    public IQueryDAO getQueryDAO() {
        return this.queryDAO;
    }

    @Override
    public IRelationshipTypeDAO getRelationshipTypeDAO() {
        return this.relationshipTypeDAO;
    }

    @Override
    public IDeletionDAO getDeletionDAO() {
        return this.deletionDAO;
    }

    @Override
    public IMetaprojectDAO getMetaprojectDAO() {
        return this.metaprojectDAO;
    }

    @Override
    public void setBatchUpdateMode(boolean batchMode) {
        SessionFactory sessionFactory = this.persistencyResources.getSessionFactory();
        Session currentSession = sessionFactory.getCurrentSession();
        HibernateUtils.setBatchUpdateMode((org.hibernate.Session)currentSession, batchMode);
    }
}

