/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationGroupDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class AuthorizationGroupDAO
extends AbstractGenericEntityDAO<AuthorizationGroupPE>
implements IAuthorizationGroupDAO {
    public static final Class<AuthorizationGroupPE> ENTITY_CLASS = AuthorizationGroupPE.class;
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AuthorizationGroupDAO.class);

    protected AuthorizationGroupDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, ENTITY_CLASS);
    }

    @Override
    public List<AuthorizationGroupPE> list() {
        List<AuthorizationGroupPE> list = AuthorizationGroupDAO.cast(this.getHibernateTemplate().find(String.format("from %s a where a.databaseInstance = ?", TABLE_NAME), AuthorizationGroupDAO.toArray(this.getDatabaseInstance())));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s(): %d authorization group(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public void create(AuthorizationGroupPE authorizationGroup) {
        assert (authorizationGroup != null) : "Missing authorization group.";
        AuthorizationGroupDAO.validatePE(authorizationGroup);
        authorizationGroup.setCode(CodeConverter.tryToDatabase(authorizationGroup.getCode()));
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)authorizationGroup);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("SAVE: authorization group '%s'.", authorizationGroup));
        }
    }

    @Override
    public AuthorizationGroupPE tryFindByCode(String code) {
        Criteria criteria = this.getSession().createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(code)));
        criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        return (AuthorizationGroupPE)criteria.uniqueResult();
    }
}

