/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IDetachedCriteriaFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdateScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexUpdateOperation;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

final class DeletionDAO
extends AbstractGenericEntityDAO<DeletionPE>
implements IDeletionDAO {
    private static final String ID = "id";
    private static final String DELETION_ID = "deletion.id";
    private static final String CONTAINER_ID = "containerId";
    private static final String ORIGINAL_DELETION = "originalDeletion";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DeletionDAO.class);
    private final PersistencyResources persistencyResources;

    DeletionDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance, PersistencyResources persistencyResources) {
        super(sessionFactory, databaseInstance, DeletionPE.class);
        this.persistencyResources = persistencyResources;
    }

    @Override
    public final void create(DeletionPE deletion) throws DataAccessException {
        assert (deletion != null) : "Unspecified deletion";
        DeletionDAO.validatePE(deletion);
        HibernateTemplate template = this.getHibernateTemplate();
        template.save((Object)deletion);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("ADD: deletion '%s'.", deletion));
        }
    }

    @Override
    public void revert(DeletionPE deletion, PersonPE modifier) throws DataAccessException {
        operationLog.info(String.format("REVERT: deletion %s.", deletion));
        EntityKind[] entityKindArray = EntityKind.values();
        int n = entityKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            if (entityKind != EntityKind.MATERIAL) {
                this.revertDeletionOfEntities(deletion, entityKind, modifier);
            }
            ++n2;
        }
        super.delete(deletion);
    }

    private void revertDeletionOfEntitiesOld(DeletionPE deletion, EntityKind entityKind) {
        assert (deletion != null) : "Unspecified deletion";
        assert (entityKind != null) : "Unspecified entity kind";
        List<TechId> ids = this.findTrashedEntityIds(Collections.singletonList(TechId.create(deletion)), entityKind, new Criterion[0]);
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        String query = String.format("UPDATE VERSIONED %s SET deletion = NULL WHERE deletion = ?", entityKind.getDeletedEntityClass().getSimpleName());
        int updatedRows = hibernateTemplate.bulkUpdate(query, (Object)deletion);
        hibernateTemplate.flush();
        hibernateTemplate.clear();
        this.scheduleDynamicPropertiesEvaluationByIds(TechId.asLongs(ids), entityKind);
        operationLog.info(String.format("%s %s(s) reverted", updatedRows, entityKind.name()));
    }

    private void revertDeletionOfEntities(final DeletionPE deletion, final EntityKind entityKind, final PersonPE modifier) {
        assert (deletion != null) : "Unspecified deletion";
        assert (entityKind != null) : "Unspecified entity kind";
        assert (modifier != null) : "Unspecified modifier";
        List<TechId> ids = this.findTrashedEntityIds(Collections.singletonList(TechId.create(deletion)), entityKind, new Criterion[0]);
        int updatedRows = (Integer)this.executeStatelessAction(new AbstractDAO.StatelessHibernateCallback(){

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                String query = String.format("UPDATE %s SET modification_timestamp = now(), del_id = NULL, orig_del = NULL, pers_id_modifier = :modifierId WHERE del_id = :deletionId", entityKind.getAllTableName());
                SQLQuery sqlQuery = session.createSQLQuery(query);
                sqlQuery.setParameter("deletionId", (Object)HibernateUtils.getId(deletion));
                sqlQuery.setParameter("modifierId", (Object)HibernateUtils.getId(modifier));
                return sqlQuery.executeUpdate();
            }
        });
        switch (entityKind) {
            case SAMPLE: {
                this.revertDeletionOfRelationships(deletion, "sample_relationships_all");
                break;
            }
            case DATA_SET: {
                this.revertDeletionOfRelationships(deletion, "data_set_relationships_all");
                break;
            }
            case EXPERIMENT: {
                break;
            }
        }
        this.revertDeletionOfRelationships(deletion, "metaproject_assignments_all");
        this.scheduleDynamicPropertiesEvaluationByIds(TechId.asLongs(ids), entityKind);
        operationLog.info(String.format("%s %s(s) reverted", updatedRows, entityKind.name()));
    }

    private void revertDeletionOfRelationships(final DeletionPE deletion, final String tableName) {
        assert (deletion != null) : "Unspecified deletion";
        int updatedRows = (Integer)this.executeStatelessAction(new AbstractDAO.StatelessHibernateCallback(){

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                String query = String.format("UPDATE %s SET del_id = NULL WHERE del_id = :deletionId", tableName);
                SQLQuery sqlQuery = session.createSQLQuery(query);
                sqlQuery.setParameter("deletionId", (Object)HibernateUtils.getId(deletion));
                return sqlQuery.executeUpdate();
            }
        });
        operationLog.info(String.format("%s %s(s) reverted", updatedRows, tableName));
    }

    @Override
    public List<TechId> findTrashedSampleIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.SAMPLE, new Criterion[0]);
    }

    @Override
    public List<TechId> findTrashedNonComponentSampleIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.SAMPLE, Restrictions.isNull((String)CONTAINER_ID));
    }

    @Override
    public List<TechId> findTrashedComponentSampleIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.SAMPLE, Restrictions.isNotNull((String)CONTAINER_ID));
    }

    @Override
    public List<TechId> findTrashedExperimentIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.EXPERIMENT, new Criterion[0]);
    }

    @Override
    public List<String> findTrashedDataSetCodes(List<TechId> deletionIds) {
        if (deletionIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> longIds = TechId.asLongs(deletionIds);
        List<String> results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(EntityKind.DATA_SET.getDeletedEntityClass());
                criteria.setProjection((Projection)Projections.property((String)"code"));
                return criteria;
            }
        }, DELETION_ID, longIds);
        operationLog.info(String.format("found %s trashed %s(s)", results.size(), EntityKind.DATA_SET.name()));
        return results;
    }

    private List<TechId> findTrashedEntityIds(List<TechId> deletionIds, final EntityKind entityKind, final Criterion ... additionalCriteria) {
        if (deletionIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> longIds = TechId.asLongs(deletionIds);
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(entityKind.getDeletedEntityClass());
                criteria.setProjection((Projection)Projections.id());
                Criterion[] criterionArray = additionalCriteria;
                int n = additionalCriteria.length;
                int n2 = 0;
                while (n2 < n) {
                    Criterion criterion = criterionArray[n2];
                    criteria.add(criterion);
                    ++n2;
                }
                return criteria;
            }
        }, DELETION_ID, longIds);
        operationLog.info(String.format("found %s trashed %s(s)", results.size(), entityKind.name()));
        return DeletionDAO.transformNumbers2TechIdList(results);
    }

    @Override
    public int trash(EntityKind entityKind, List<TechId> entityIds, DeletionPE deletion) throws DataAccessException {
        return this.trash(entityKind, entityIds, deletion, false);
    }

    @Override
    public int trash(final EntityKind entityKind, final List<TechId> entityIds, final DeletionPE deletion, final boolean isOriginalDeletion) throws DataAccessException {
        if (entityIds.isEmpty()) {
            return 0;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int updatedRows = (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("UPDATE VERSIONED " + entityKind.getEntityClass().getSimpleName() + " SET deletion = :deletion" + ", originalDeletion = " + (isOriginalDeletion ? " :deletion" : " NULL") + " WHERE deletion IS NULL AND id IN (:ids) ").setParameter("deletion", (Object)deletion).setParameterList("ids", TechId.asLongs(entityIds)).executeUpdate();
            }
        });
        switch (entityKind) {
            case SAMPLE: {
                this.trashSampleRelationships(entityIds, deletion);
                break;
            }
            case DATA_SET: {
                this.trashDataSetRelationships(entityIds, deletion);
                break;
            }
            case EXPERIMENT: {
                break;
            }
        }
        this.trashMetaprojectAssignments(entityIds, entityKind, deletion);
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("trashing %d %ss", updatedRows, entityKind.getLabel()));
        }
        hibernateTemplate.flush();
        List<Long> ids = TechId.asLongs(entityIds);
        this.scheduleRemoveFromFullTextIndex(ids, entityKind);
        return updatedRows;
    }

    private int trashSampleRelationships(final List<TechId> samplesIds, final DeletionPE deletion) throws DataAccessException {
        if (samplesIds.isEmpty()) {
            return 0;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int updatedRows = (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("UPDATE " + SampleRelationshipPE.class.getSimpleName() + " SET deletion = :deletion, author = :author" + " WHERE deletion IS NULL" + " AND (parentSample.id IN (:ids) OR childSample.id in (:ids))").setParameter("deletion", (Object)deletion).setParameter("author", (Object)deletion.getRegistrator()).setParameterList("ids", TechId.asLongs(samplesIds)).executeUpdate();
            }
        });
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("trashing %d %ss", updatedRows, "sample relationships."));
        }
        hibernateTemplate.flush();
        return updatedRows;
    }

    private int trashMetaprojectAssignments(final List<TechId> entityIds, final EntityKind entityKind, final DeletionPE deletion) throws DataAccessException {
        if (entityIds.isEmpty()) {
            return 0;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int updatedRows = (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("UPDATE " + MetaprojectAssignmentPE.class.getSimpleName() + " SET deletion = :deletion" + " WHERE deletion IS NULL" + " AND " + entityKind.getLabel() + ".id IN (:ids)").setParameter("deletion", (Object)deletion).setParameterList("ids", TechId.asLongs(entityIds)).executeUpdate();
            }
        });
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("trashing %d %ss", updatedRows, String.valueOf(entityKind.getLabel()) + " metaproject assignments."));
        }
        hibernateTemplate.flush();
        return updatedRows;
    }

    private int trashDataSetRelationships(final List<TechId> dataSetIds, final DeletionPE deletion) throws DataAccessException {
        if (dataSetIds.isEmpty()) {
            return 0;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int updatedRows = (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("UPDATE " + DataSetRelationshipPE.class.getSimpleName() + " SET deletion = :deletion, author = :author" + " WHERE deletion IS NULL" + " AND (parentDataSet.id IN (:ids) OR childDataSet.id in (:ids))").setParameter("deletion", (Object)deletion).setParameter("author", (Object)deletion.getRegistrator()).setParameterList("ids", TechId.asLongs(dataSetIds)).executeUpdate();
            }
        });
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("trashing %d %ss", updatedRows, "data set relationships."));
        }
        hibernateTemplate.flush();
        return updatedRows;
    }

    @Override
    public List<DeletionPE> findAllById(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List<DeletionPE> result = DAOUtils.listByCollection(this.getHibernateTemplate(), DeletionPE.class, ID, ids);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s deletions has been found", result.size()));
        }
        return result;
    }

    protected IFullTextIndexUpdateScheduler getIndexUpdateScheduler() {
        return this.persistencyResources.getIndexUpdateScheduler();
    }

    protected IDynamicPropertyEvaluationScheduler getDynamicPropertyEvaluatorScheduler() {
        return this.persistencyResources.getDynamicPropertyEvaluationScheduler();
    }

    protected void scheduleRemoveFromFullTextIndex(List<Long> ids, EntityKind entityKind) {
        this.getIndexUpdateScheduler().scheduleUpdate(IndexUpdateOperation.remove(entityKind.getEntityClass(), ids));
    }

    protected void scheduleDynamicPropertiesEvaluationByIds(List<Long> ids, EntityKind entityKind) {
        DeletionDAO.scheduleDynamicPropertiesEvaluationForIds(this.getDynamicPropertyEvaluatorScheduler(), entityKind.getEntityClass(), ids);
    }

    @Override
    public List<TechId> findTrashedDataSetIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.DATA_SET, new Criterion[0]);
    }

    @Override
    public List<? extends IDeletablePE> listDeletedEntities(EntityKind entityKind, List<TechId> entityIds) {
        if (entityIds.isEmpty()) {
            return Collections.emptyList();
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        List<Long> ids = TechId.asLongs(entityIds);
        return DAOUtils.listByCollection(hibernateTemplate, entityKind.getDeletedEntityClass(), ID, ids);
    }

    @Override
    public List<TechId> listDeletedEntitiesForType(EntityKind entityKind, TechId entityTypeId) {
        String typeId = null;
        switch (entityKind) {
            case EXPERIMENT: {
                typeId = "experimentType.id";
                break;
            }
            case SAMPLE: {
                typeId = "sampleType.id";
                break;
            }
            case DATA_SET: {
                typeId = "dataSetType.id";
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(entityKind.getDeletedEntityClass());
        criteria.setProjection((Projection)Projections.id());
        criteria.add((Criterion)Restrictions.eq((String)typeId, (Object)entityTypeId.getId()));
        List<Long> result = DeletionDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        return TechId.createList(result);
    }

    @Override
    public List<TechId> findOriginalTrashedDataSetIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.DATA_SET, Restrictions.isNotNull((String)ORIGINAL_DELETION));
    }

    @Override
    public List<TechId> findOriginalTrashedExperimentIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.EXPERIMENT, Restrictions.isNotNull((String)ORIGINAL_DELETION));
    }

    @Override
    public List<TechId> findOriginalTrashedSampleIds(List<TechId> deletionIds) {
        return this.findTrashedEntityIds(deletionIds, EntityKind.SAMPLE, Restrictions.isNotNull((String)ORIGINAL_DELETION));
    }
}

