/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityHistoryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractEntityPropertyHistoryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.List;
import org.apache.log4j.Logger;

class EntityHistoryDAO
extends AbstractDAO
implements IEntityHistoryDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, EntityHistoryDAO.class);

    EntityHistoryDAO(PersistencyResources persistencyResources, DatabaseInstancePE databaseInstance) {
        super(persistencyResources.getSessionFactory(), databaseInstance);
    }

    @Override
    public List<AbstractEntityPropertyHistoryPE> getPropertyHistory(EntityKind entityKind, TechId id) {
        List<AbstractEntityPropertyHistoryPE> result = EntityHistoryDAO.cast(this.getHibernateTemplate().find(String.format("from %s eh where eh.entityInternal.id = ?", entityKind.getEntityPropertyHistoryClass().getSimpleName()), EntityHistoryDAO.toArray(id.getId())));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(result.size()) + " historical property values have been found for entity " + id + " which is of entity kind " + (Object)((Object)entityKind) + ".");
        }
        return result;
    }
}

