/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityOperationsLogDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityOperationsLogEntryPE;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class EntityOperationsLogDAO
extends AbstractGenericEntityDAO<EntityOperationsLogEntryPE>
implements IEntityOperationsLogDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, EntityOperationsLogDAO.class);

    protected EntityOperationsLogDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, EntityOperationsLogEntryPE.class);
    }

    @Override
    public void addLogEntry(Long registrationId) {
        EntityOperationsLogEntryPE logEntry = new EntityOperationsLogEntryPE();
        logEntry.setRegistrationId(registrationId);
        HibernateTemplate template = this.getHibernateTemplate();
        template.persist((Object)logEntry);
        template.flush();
        operationLog.info(String.format("Add entity operation log entry for registration id '%d'.", registrationId));
    }

    @Override
    public EntityOperationsLogEntryPE tryFindLogEntry(Long registrationId) {
        assert (registrationId != null) : "Unspecified registration id.";
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"registrationId", (Object)registrationId));
        EntityOperationsLogEntryPE result = (EntityOperationsLogEntryPE)criteria.uniqueResult();
        if (result != null) {
            operationLog.info(String.format("Found a log entry for registration id '%d'.", registrationId));
        } else {
            operationLog.info(String.format("Did not find a log entry for registration id '%d'.", registrationId));
        }
        return result;
    }
}

