/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.HibernateSearchDataProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.MetaprojectSearch;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.HibernateSearchContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.LuceneQueryBuilder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchAssociationCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.hibernate.SearchFieldConstants;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.search.IgnoreCaseAnalyzer;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TokenGroup;
import org.apache.lucene.search.highlight.TokenSources;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

final class HibernateSearchDAO
extends HibernateDaoSupport
implements IHibernateSearchDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HibernateSearchDAO.class);
    private final HibernateSearchContext hibernateSearchContext;

    HibernateSearchDAO(SessionFactory sessionFactory, HibernateSearchContext hibernateSearchContext) {
        assert (sessionFactory != null) : "Unspecified session factory";
        this.hibernateSearchContext = hibernateSearchContext;
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public int getResultSetSizeLimit() {
        return this.hibernateSearchContext.getMaxResults();
    }

    @Override
    public List<MatchingEntity> searchEntitiesByTerm(final String userId, final SearchableEntity searchableEntity, final String searchTerm, final HibernateSearchDataProvider dataProvider, final boolean useWildcardSearchMode, final int alreadyFoundEntities, final int maxSize) throws DataAccessException {
        assert (searchableEntity != null) : "Unspecified searchable entity";
        assert (!StringUtils.isBlank((String)searchTerm)) : "Unspecified search term.";
        assert (dataProvider != null) : "Unspecified data provider";
        List<MatchingEntity> list = AbstractDAO.cast((List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final List<MatchingEntity> doInHibernate(Session session) throws HibernateException, SQLException {
                return HibernateSearchDAO.this.doSearchEntitiesByTerm(userId, session, searchableEntity, searchTerm, dataProvider, useWildcardSearchMode, alreadyFoundEntities, maxSize);
            }
        }));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d matching entities of type '%s' have been found for search term '%s'.", list.size(), searchableEntity.getMatchingEntityClass(), searchTerm));
        }
        return list;
    }

    private final List<MatchingEntity> doSearchEntitiesByTerm(String userId, Session session, SearchableEntity searchableEntity, String userQuery, HibernateSearchDataProvider dataProvider, boolean useWildcardSearchMode, int alreadyFoundEntities, int maxSize) throws DataAccessException, UserFailureException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Analyzer analyzer = LuceneQueryBuilder.createSearchAnalyzer();
        MyIndexReaderProvider indexProvider = new MyIndexReaderProvider(fullTextSession, searchableEntity);
        try {
            String[] fields;
            ArrayList<MatchingEntity> result = new ArrayList<MatchingEntity>();
            String[] stringArray = fields = indexProvider.getIndexedFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                List<MatchingEntity> hits = this.searchTermInField(userId, fullTextSession, fieldName, userQuery, searchableEntity, analyzer, indexProvider.getReader(), dataProvider, useWildcardSearchMode, result.size() + alreadyFoundEntities, maxSize);
                result.addAll(hits);
                ++n2;
            }
            ArrayList<MatchingEntity> arrayList = result;
            return arrayList;
        }
        finally {
            indexProvider.close();
        }
    }

    private final List<MatchingEntity> searchTermInField(String userId, FullTextSession fullTextSession, String fieldName, String userQuery, SearchableEntity searchableEntity, Analyzer analyzer, IndexReader indexReader, HibernateSearchDataProvider dataProvider, boolean useWildcardSearchMode, int alreadyFoundResults, int maxSize) throws DataAccessException, UserFailureException {
        String searchTerm;
        int maxResults = Math.max(0, Math.min(maxSize, this.hibernateSearchContext.getMaxResults()) - alreadyFoundResults);
        if (maxResults == 0) {
            return new ArrayList<MatchingEntity>();
        }
        Query query = null;
        Analyzer chosenAnalyzer = analyzer;
        if (MetaprojectSearch.isMetaprojectField(fieldName)) {
            searchTerm = LuceneQueryBuilder.adaptQuery(MetaprojectSearch.getMetaprojectUserQuery(userQuery, userId), useWildcardSearchMode, false);
            chosenAnalyzer = new IgnoreCaseAnalyzer();
            query = LuceneQueryBuilder.parseQuery(fieldName, searchTerm, chosenAnalyzer);
        } else {
            searchTerm = LuceneQueryBuilder.adaptQuery(userQuery, useWildcardSearchMode);
            query = LuceneQueryBuilder.parseQuery(fieldName, searchTerm, analyzer);
        }
        query = HibernateSearchDAO.rewriteQuery(indexReader, query);
        FullTextQuery hibernateQuery = fullTextSession.createFullTextQuery(query, new Class[]{searchableEntity.getMatchingEntityClass()});
        hibernateQuery.setProjection(new String[]{"__HSearch_DocumentId", "__HSearch_Document"});
        hibernateQuery.setReadOnly(true);
        hibernateQuery.setFirstResult(0);
        hibernateQuery.setMaxResults(maxResults);
        MyHighlighter highlighter = new MyHighlighter(query, indexReader, chosenAnalyzer);
        hibernateQuery.setResultTransformer((ResultTransformer)new MatchingEntityResultTransformer(searchableEntity, fieldName, highlighter, dataProvider));
        List list = hibernateQuery.list();
        List result = AbstractDAO.cast(list);
        return HibernateSearchDAO.filterNulls(result);
    }

    private static Query rewriteQuery(IndexReader indexReader, Query query) {
        try {
            return query.rewrite(indexReader);
        }
        catch (IOException ex) {
            HibernateSearchDAO.logSearchHighlightingError(ex);
            return query;
        }
    }

    @Override
    public List<Long> searchForEntityIds(final String userId, final DetailedSearchCriteria criteria, final EntityKind entityKind, final List<DetailedSearchAssociationCriteria> associations) {
        List<Long> list = AbstractDAO.cast((List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                return HibernateSearchDAO.this.searchForEntityIds(userId, session, criteria, entityKind, associations);
            }
        }));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d matching samples have been found for search criteria '%s'.", list.size(), criteria.toString()));
        }
        return list;
    }

    private List<Long> searchForEntityIds(String userId, Session session, DetailedSearchCriteria searchCriteria, EntityKind entityKind, List<DetailedSearchAssociationCriteria> associations) {
        Query query = LuceneQueryBuilder.createDetailedSearchQuery(userId, searchCriteria, associations, entityKind);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery hibernateQuery = fullTextSession.createFullTextQuery(query, new Class[]{entityKind.getEntityClass()});
        hibernateQuery.setProjection(new String[]{"__HSearch_id"});
        hibernateQuery.setReadOnly(true);
        hibernateQuery.setResultTransformer((ResultTransformer)new PassThroughOneObjectTupleResultTransformer());
        List<Long> entityIds = AbstractDAO.cast(hibernateQuery.list());
        entityIds = HibernateSearchDAO.filterNulls(entityIds);
        return entityIds;
    }

    private static <T> List<T> filterNulls(List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : list) {
            if (elem == null) continue;
            result.add(elem);
        }
        return result;
    }

    private static void logSearchHighlightingError(Exception ex) {
        operationLog.error("error during search result highlighting: " + ex.getMessage());
    }

    private static class MatchingEntityResultTransformer
    implements ResultTransformer {
        private final SearchableEntity searchableEntity;
        private final String fieldName;
        private final MyHighlighter highlighter;
        private final HibernateSearchDataProvider dataProvider;
        private static final long serialVersionUID = 1L;

        public MatchingEntityResultTransformer(SearchableEntity searchableEntity, String fieldName, MyHighlighter highlighter, HibernateSearchDataProvider dataProvider) {
            this.searchableEntity = searchableEntity;
            this.fieldName = fieldName;
            this.highlighter = highlighter;
            this.dataProvider = dataProvider;
        }

        public List transformList(List collection) {
            throw new IllegalStateException("This method should not be called");
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            int documentId = (Integer)tuple[0];
            Document doc = (Document)tuple[1];
            String matchingText = null;
            try {
                String content = doc.get(this.fieldName);
                matchingText = content != null ? this.highlighter.getBestFragment(content, this.fieldName, documentId) : "[content]";
            }
            catch (IOException ex) {
                HibernateSearchDAO.logSearchHighlightingError(ex);
            }
            catch (InvalidTokenOffsetsException ex) {
                HibernateSearchDAO.logSearchHighlightingError((Exception)((Object)ex));
            }
            return this.createMatchingEntity(doc, matchingText);
        }

        private MatchingEntity createMatchingEntity(Document doc, String matchingText) {
            MatchingEntity result = new MatchingEntity();
            result.setFieldDescription(this.fieldName);
            result.setTextFragment(matchingText);
            result.setCode(this.getFieldValue(doc, "code"));
            result.setId(Long.parseLong(this.getFieldValue(doc, "id")));
            result.setIdentifier(this.getFieldValue(doc, "identifier"));
            result.setPermId(this.tryGetFieldValue(doc, "perm_id"));
            result.setEntityKind(DtoConverters.convertEntityKind(this.searchableEntity.getEntityKind()));
            BasicEntityType entityType = new BasicEntityType();
            entityType.setCode(this.getFieldValue(doc, "type code"));
            result.setEntityType(entityType);
            Map<String, Space> spacesById = this.dataProvider.getGroupsById();
            Field spaceFieldOrNull = doc.getField(this.getSpaceIdFieldName());
            if (spaceFieldOrNull != null) {
                Space space = spacesById.get(spaceFieldOrNull.stringValue());
                result.setSpace(space);
            }
            String registratorIdOrNull = this.tryGetFieldValue(doc, "registrator User Id");
            String firstNameOrNull = this.tryGetFieldValue(doc, "registrator First Name");
            if (registratorIdOrNull != null || firstNameOrNull != null) {
                Person registrator = new Person();
                registrator.setUserId(registratorIdOrNull);
                registrator.setFirstName(firstNameOrNull);
                registrator.setLastName(this.tryGetFieldValue(doc, "registrator Last Name"));
                registrator.setEmail(this.tryGetFieldValue(doc, "registrator Email"));
                result.setRegistrator(registrator);
            }
            return result;
        }

        private String getFieldValue(Document document, String searchFieldName) {
            return document.getField(searchFieldName).stringValue();
        }

        private String tryGetFieldValue(Document document, String searchFieldName) {
            Field fieldOrNull = document.getField(searchFieldName);
            return fieldOrNull == null ? null : fieldOrNull.stringValue();
        }

        private String getSpaceIdFieldName() {
            String groupId = "space id";
            if (this.searchableEntity.equals((Object)SearchableEntity.EXPERIMENT)) {
                return "project " + groupId;
            }
            return groupId;
        }
    }

    private static final class MyHighlighter {
        private final IndexReader indexReader;
        private final Analyzer analyzer;
        private final Highlighter highlighter;

        public MyHighlighter(Query query, IndexReader indexReader, Analyzer analyzer) {
            this.highlighter = MyHighlighter.createHighlighter(query);
            this.indexReader = indexReader;
            this.analyzer = analyzer;
        }

        private static Highlighter createHighlighter(Query query) {
            Formatter htmlFormatter = MyHighlighter.createFormatter();
            return new Highlighter(htmlFormatter, (Scorer)new QueryScorer(query));
        }

        private static Formatter createFormatter() {
            return new Formatter(){

                public String highlightTerm(String text, TokenGroup tokenGroup) {
                    return text;
                }
            };
        }

        public String getBestFragment(String fieldContent, String fieldName, int documentId) throws IOException, InvalidTokenOffsetsException {
            TokenStream tokenStream = TokenSources.getAnyTokenStream((IndexReader)this.indexReader, (int)documentId, (String)fieldName, (Analyzer)this.analyzer);
            return this.highlighter.getBestFragment(tokenStream, fieldContent);
        }
    }

    private static final class MyIndexReaderProvider {
        private final ReaderProvider readerProvider;
        private final IndexReader indexReader;

        public MyIndexReaderProvider(FullTextSession fullTextSession, SearchableEntity searchableEntity) {
            SearchFactory searchFactory = fullTextSession.getSearchFactory();
            DirectoryProvider[] directoryProviders = searchFactory.getDirectoryProviders(searchableEntity.getMatchingEntityClass());
            this.readerProvider = searchFactory.getReaderProvider();
            this.indexReader = this.readerProvider.openReader(directoryProviders);
        }

        public IndexReader getReader() {
            return this.indexReader;
        }

        public String[] getIndexedFields() {
            HashSet<String> fieldNames = new HashSet<String>();
            for (Object fieldName : this.indexReader.getFieldNames(IndexReader.FieldOption.INDEXED)) {
                fieldNames.add(fieldName.toString());
            }
            fieldNames.remove("_hibernate_class");
            fieldNames.remove("id");
            String[] stringArray = SearchFieldConstants.PREFIXES;
            int n = SearchFieldConstants.PREFIXES.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                fieldNames.remove(String.valueOf(prefix) + "id");
                ++n2;
            }
            return fieldNames.toArray(new String[fieldNames.size()]);
        }

        public void close() {
            this.readerProvider.closeReader(this.indexReader);
        }
    }

    private static class PassThroughOneObjectTupleResultTransformer
    extends BasicTransformerAdapter {
        private static final long serialVersionUID = 1L;

        private PassThroughOneObjectTupleResultTransformer() {
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            assert (tuple.length == 1) : "tuple should consist of exactly one object";
            return tuple[0];
        }
    }
}

