/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityWithPropertiesDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IDetachedCriteriaFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SampleDataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class SampleDAO
extends AbstractGenericEntityWithPropertiesDAO<SamplePE>
implements ISampleDAO {
    private static final Class<SamplePE> ENTITY_CLASS = SamplePE.class;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SampleDAO.class);

    SampleDAO(PersistencyResources persistencyResources, DatabaseInstancePE databaseInstance) {
        super(persistencyResources, databaseInstance, SamplePE.class);
    }

    private final void internalCreateOrUpdateSample(SamplePE sample, PersonPE modifier, HibernateTemplate hibernateTemplate, boolean doLog) {
        SampleDAO.validatePE(sample);
        sample.setCode(CodeConverter.tryToDatabase(sample.getCode()));
        if (sample.getModificationDate() == null) {
            sample.setModificationDate(new Date());
        }
        this.lockEntity(sample.getExperiment());
        this.lockEntity(sample.getContainer());
        this.lockEntities(sample.getParents());
        hibernateTemplate.saveOrUpdate((Object)sample);
        if (doLog && operationLog.isInfoEnabled()) {
            operationLog.info(String.format("ADD: sample '%s'.", sample));
        }
    }

    @Override
    public final void createOrUpdateSample(SamplePE sample, PersonPE modifier) throws DataAccessException {
        assert (sample != null) : "Unspecified sample";
        try {
            HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
            this.internalCreateOrUpdateSample(sample, modifier, hibernateTemplate, true);
            SampleDAO.flushWithSqlExceptionHandling(hibernateTemplate);
            this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(sample));
            SampleDAO.scheduleDynamicPropertiesEvaluation(this.getDynamicPropertyEvaluatorScheduler(), DataPE.class, new ArrayList<DataPE>(sample.getDatasets()));
        }
        catch (DataAccessException e) {
            SampleDataAccessExceptionTranslator.translateAndThrow(e);
        }
    }

    @Override
    public final List<SamplePE> listSamplesByGeneratedFrom(SamplePE sample) {
        return sample.getGenerated();
    }

    @Override
    public final List<SamplePE> listSamplesBySpaceAndProperty(String propertyCode, String propertyValue, SpacePE space) throws DataAccessException {
        assert (space != null) : "Unspecified space.";
        assert (propertyCode != null) : "Unspecified property code";
        assert (propertyValue != null) : "Unspecified property value";
        String queryFormat = "from " + SamplePropertyPE.class.getSimpleName() + " where %s = ? and entity.space = ? " + " and entityTypePropertyType.propertyTypeInternal.simpleCode = ?" + " and entityTypePropertyType.propertyTypeInternal.internalNamespace = ?";
        List<SamplePE> entities = this.listByPropertyValue(queryFormat, propertyCode, propertyValue, space);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d samples have been found for space '%s' and property '%s' equal to '%s'.", entities.size(), space, propertyCode, propertyValue));
        }
        return entities;
    }

    private List<SamplePE> listByPropertyValue(String queryFormat, String propertyCode, String propertyValue, SpacePE parent) {
        String simplePropertyCode = CodeConverter.tryToDatabase(propertyCode);
        boolean isInternalNamespace = CodeConverter.isInternalNamespace(propertyCode);
        Object[] arguments = SampleDAO.toArray(propertyValue, parent, simplePropertyCode, isInternalNamespace);
        String queryPropertySimpleValue = String.format(queryFormat, "value");
        List<SamplePropertyPE> properties1 = SampleDAO.cast(this.getHibernateTemplate().find(queryPropertySimpleValue, arguments));
        String queryPropertyVocabularyTerm = String.format(queryFormat, "vocabularyTerm.code");
        List properties2 = SampleDAO.cast(this.getHibernateTemplate().find(queryPropertyVocabularyTerm, arguments));
        properties1.addAll(properties2);
        List<SamplePE> entities = SampleDAO.extractEntities(properties1);
        return entities;
    }

    private static List<SamplePE> extractEntities(List<SamplePropertyPE> properties) {
        ArrayList<SamplePE> samples = new ArrayList<SamplePE>();
        for (SamplePropertyPE prop : properties) {
            samples.add(prop.getEntity());
        }
        return samples;
    }

    @Override
    public SamplePE tryToFindByPermID(String permID) throws DataAccessException {
        assert (permID != null) : "Unspecified permanent ID.";
        Criteria criteria = this.getSession().createCriteria(ENTITY_CLASS);
        criteria.add((Criterion)Restrictions.eq((String)"permId", (Object)permID));
        criteria.setFetchMode("sampleType.sampleTypePropertyTypesInternal", FetchMode.JOIN);
        SamplePE sample = (SamplePE)criteria.uniqueResult();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Following sample '%s' has been found for permanent ID '%s'.", sample, permID));
        }
        return sample;
    }

    @Override
    public final SamplePE tryFindByCodeAndDatabaseInstance(String sampleCode, DatabaseInstancePE databaseInstance) {
        assert (sampleCode != null) : "Unspecified sample code.";
        assert (databaseInstance != null) : "Unspecified database instance.";
        Criteria criteria = this.createDatabaseInstanceCriteria(databaseInstance);
        this.addSampleCodeCriterion(criteria, sampleCode);
        SamplePE sample = (SamplePE)criteria.uniqueResult();
        if (sample == null && !this.isFullCode(sampleCode)) {
            criteria = this.createDatabaseInstanceCriteria(databaseInstance);
            sample = this.tryFindContainedSampleWithUniqueSubcode(criteria, sampleCode);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Following sample '%s' has been found for code '%s' and database instance '%s'.", sample, sampleCode, databaseInstance));
        }
        return sample;
    }

    @Override
    public final List<SamplePE> listByCodesAndDatabaseInstance(List<String> sampleCodes, String containerCodeOrNull, DatabaseInstancePE databaseInstance) {
        assert (sampleCodes != null) : "Unspecified sample codes.";
        assert (databaseInstance != null) : "Unspecified database instance.";
        Criteria criteria = this.createDatabaseInstanceCriteria(databaseInstance);
        this.addSampleCodesCriterion(criteria, sampleCodes, containerCodeOrNull);
        List<SamplePE> result = SampleDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s samples has been found", result.size()));
        }
        return result;
    }

    @Override
    public final SamplePE tryFindByCodeAndSpace(String sampleCode, SpacePE space) {
        assert (sampleCode != null) : "Unspecified sample code.";
        assert (space != null) : "Unspecified space.";
        Criteria criteria = this.createSpaceCriteria(space);
        this.addSampleCodeCriterion(criteria, sampleCode);
        SamplePE sample = (SamplePE)criteria.uniqueResult();
        if (sample == null && !this.isFullCode(sampleCode)) {
            criteria = this.createSpaceCriteria(space);
            sample = this.tryFindContainedSampleWithUniqueSubcode(criteria, sampleCode);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Following sample '%s' has been found for code '%s' and space '%s'.", sample, sampleCode, space));
        }
        return sample;
    }

    @Override
    public final List<SamplePE> listByCodesAndSpace(List<String> sampleCodes, String containerCodeOrNull, SpacePE space) {
        assert (sampleCodes != null) : "Unspecified sample codes.";
        assert (space != null) : "Unspecified space.";
        Criteria criteria = this.createSpaceCriteria(space);
        this.addSampleCodesCriterion(criteria, sampleCodes, containerCodeOrNull);
        List<SamplePE> result = SampleDAO.cast(criteria.list());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s samples has been found", result.size()));
        }
        return result;
    }

    private boolean isFullCode(String sampleCode) {
        return sampleCode.contains(":");
    }

    private SamplePE tryFindContainedSampleWithUniqueSubcode(Criteria criteria, String sampleCode) {
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(sampleCode)));
        criteria.add(Restrictions.isNotNull((String)"container"));
        List list = SampleDAO.cast(criteria.list());
        return list.size() == 1 ? (SamplePE)list.get(0) : null;
    }

    private Criteria createFindCriteria(Criterion criterion) {
        Criteria criteria = this.getSession().createCriteria(ENTITY_CLASS);
        criteria.setFetchMode("sampleType.sampleTypePropertyTypesInternal", FetchMode.JOIN);
        criteria.add(criterion);
        return criteria;
    }

    private Criteria createDatabaseInstanceCriteria(DatabaseInstancePE databaseInstance) {
        return this.createFindCriteria((Criterion)Restrictions.eq((String)"databaseInstance", (Object)databaseInstance));
    }

    private Criteria createSpaceCriteria(SpacePE space) {
        return this.createFindCriteria((Criterion)Restrictions.eq((String)"space", (Object)space));
    }

    private void addSampleCodesCriterion(Criteria criteria, List<String> sampleCodes, String containerCodeOrNull) {
        ArrayList<String> convertedCodes = new ArrayList<String>();
        for (String sampleCode : sampleCodes) {
            convertedCodes.add(CodeConverter.tryToDatabase(sampleCode));
        }
        criteria.add(Restrictions.in((String)"code", convertedCodes));
        criteria.setFetchMode("sampleProperties", FetchMode.JOIN);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.addSampleContainerCriterion(criteria, containerCodeOrNull);
    }

    private void addSampleCodeCriterion(Criteria criteria, String sampleCode) {
        String[] sampleCodeTokens = sampleCode.split(":");
        String subCode = sampleCodeTokens.length > 1 ? sampleCodeTokens[1] : sampleCode;
        String containerCodeOrNull = sampleCodeTokens.length > 1 ? sampleCodeTokens[0] : null;
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(subCode)));
        this.addSampleContainerCriterion(criteria, containerCodeOrNull);
    }

    private void addSampleContainerCriterion(Criteria criteria, String containerCodeOrNull) {
        if (containerCodeOrNull != null) {
            criteria.createAlias("container", "c");
            criteria.add((Criterion)Restrictions.eq((String)"c.code", (Object)CodeConverter.tryToDatabase(containerCodeOrNull)));
        } else {
            criteria.add(Restrictions.isNull((String)"container"));
        }
    }

    @Override
    public final void createOrUpdateSamples(List<SamplePE> samples, PersonPE modifier, boolean clearCache) throws DataAccessException {
        assert (samples != null && samples.size() > 0) : "Unspecified or empty samples.";
        try {
            HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
            for (SamplePE samplePE : samples) {
                this.internalCreateOrUpdateSample(samplePE, modifier, hibernateTemplate, false);
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info(String.format("ADD: %d samples.", samples.size()));
            }
            SampleDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
            this.scheduleDynamicPropertiesEvaluation(samples);
            if (clearCache) {
                hibernateTemplate.clear();
            }
        }
        catch (DataAccessException e) {
            SampleDataAccessExceptionTranslator.translateAndThrow(e);
        }
    }

    @Override
    public final void updateSample(SamplePE sample, PersonPE modifier) throws DataAccessException {
        assert (sample != null) : "Unspecified sample";
        try {
            sample.setModifier(modifier);
            SampleDAO.validatePE(sample);
            SampleDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
            this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(sample));
            if (operationLog.isInfoEnabled()) {
                operationLog.info("UPDATE: sample '" + sample + "'.");
            }
        }
        catch (DataAccessException e) {
            SampleDataAccessExceptionTranslator.translateAndThrow(e);
        }
    }

    @Override
    public List<SamplePE> listByPermID(Set<String> values) {
        return this.listByIDsOfName("permId", values);
    }

    @Override
    public List<SamplePE> listByIDs(Collection<Long> ids) {
        return this.listByIDsOfName("id", ids);
    }

    private List<SamplePE> listByIDsOfName(String idName, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return new ArrayList<SamplePE>();
        }
        List<SamplePE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), SamplePE.class, idName, values);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d sample(s) have been found.", list.size()));
        }
        return list;
    }

    @Override
    public void delete(List<TechId> sampleIds, PersonPE registrator, String reason) throws DataAccessException {
        String sqlSelectPermIds = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createSelectPermIdsSQL("samples_all");
        String sqlDeleteProperties = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeletePropertiesSQL("sample_properties", "samp_id");
        String sqlSelectAttachmentContentIds = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createSelectAttachmentContentIdsSQL("samp_id");
        String sqlDeleteAttachmentContents = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteAttachmentContentsSQL();
        String sqlDeleteAttachments = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteAttachmentsSQL("samp_id");
        String sqlDeleteSamples = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteEnitiesSQL("samples_all");
        String sqlInsertEvent = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createInsertEventSQL();
        this.executePermanentDeleteAction(EventPE.EntityType.SAMPLE, sampleIds, registrator, reason, sqlSelectPermIds, sqlDeleteProperties, sqlSelectAttachmentContentIds, sqlDeleteAttachmentContents, sqlDeleteAttachments, sqlDeleteSamples, sqlInsertEvent);
    }

    @Override
    public void deletePermanently(final DeletionPE deletion, final PersonPE registrator) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                String permIdQuery = "SELECT perm_id FROM samples_all WHERE del_id = :id";
                String properties = "DELETE FROM sample_properties WHERE samp_id IN (SELECT id FROM samples_all WHERE del_id = :id)";
                String attachmentContentIdQuery = "SELECT exac_id FROM attachments WHERE samp_id IN (SELECT id FROM samples_all WHERE del_id = :id)";
                String attachments = "DELETE FROM attachments WHERE samp_id IN (SELECT id FROM samples_all WHERE del_id = :id)";
                String attachmentContents = "DELETE FROM attachment_contents WHERE id IN (:ids)";
                String samples = "DELETE FROM samples_all WHERE del_id = :id";
                String event = "INSERT INTO events (id, event_type, description, reason, pers_id_registerer, entity_type, identifiers) VALUES (nextval('EVENT_ID_SEQ'), 'DELETION', :description, :reason, :registerer, 'SAMPLE', :identifiers)";
                SQLQuery getPermIds = session.createSQLQuery(permIdQuery);
                getPermIds.setParameter("id", (Object)deletion.getId());
                StringBuffer permIdList = new StringBuffer();
                for (String id : getPermIds.list()) {
                    permIdList.append(", ");
                    permIdList.append(id);
                }
                if (permIdList.length() == 0) {
                    return null;
                }
                String permIds = permIdList.substring(2);
                SQLQuery deleteProperties = session.createSQLQuery(properties);
                deleteProperties.setParameter("id", (Object)deletion.getId());
                deleteProperties.executeUpdate();
                SQLQuery getAttachmentContentIds = session.createSQLQuery(attachmentContentIdQuery);
                getAttachmentContentIds.setParameter("id", (Object)deletion.getId());
                List attachmentContentIdList = getAttachmentContentIds.list();
                SQLQuery deleteAttachments = session.createSQLQuery(attachments);
                deleteAttachments.setParameter("id", (Object)deletion.getId());
                deleteAttachments.executeUpdate();
                if (attachmentContentIdList.size() > 0) {
                    SQLQuery deleteAttachmentContents = session.createSQLQuery(attachmentContents);
                    deleteAttachmentContents.setParameterList("ids", (Collection)attachmentContentIdList);
                    deleteAttachmentContents.executeUpdate();
                }
                SQLQuery deleteSamples = session.createSQLQuery(samples);
                deleteSamples.setParameter("id", (Object)deletion.getId());
                deleteSamples.executeUpdate();
                SQLQuery insertEvent = session.createSQLQuery(event);
                insertEvent.setParameter("description", (Object)permIds);
                insertEvent.setParameter("reason", (Object)deletion.getReason());
                insertEvent.setParameter("registerer", (Object)registrator.getId());
                insertEvent.setParameter("identifiers", (Object)permIds);
                insertEvent.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public Set<TechId> listSampleIdsByChildrenIds(final Collection<TechId> children, final TechId relationship) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                List<Long> longIds = TechId.asLongs(children);
                return session.createSQLQuery("select sample_id_parent from sample_relationships where sample_id_child in (:ids) and relationship_id = :r ").setParameterList("ids", longIds).setParameter("r", (Object)relationship.getId()).list();
            }
        });
        Set<TechId> result = SampleDAO.transformNumbers2TechIdSet(results);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("found %d sample parents for given children", results.size()));
        }
        return result;
    }

    @Override
    public Set<TechId> listSampleIdsByParentIds(Collection<TechId> parentIds) {
        return this.listChildrenIds(parentIds, "sample_relationships");
    }

    @Override
    public Set<TechId> listChildrenForTrashedSamples(Collection<TechId> parentIds) {
        return this.listChildrenIds(parentIds, "sample_relationships_all");
    }

    private Set<TechId> listChildrenIds(final Collection<TechId> parents, String tableName) {
        final String query = "SELECT sample_id_child FROM " + tableName + " WHERE sample_id_parent IN (:ids)";
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                List<Long> longIds = TechId.asLongs(parents);
                return session.createSQLQuery(query).setParameterList("ids", longIds).list();
            }
        });
        Set<TechId> result = SampleDAO.transformNumbers2TechIdSet(results);
        if (operationLog.isDebugEnabled()) {
            operationLog.info(String.format("found %d sample children for given parents", results.size()));
        }
        return result;
    }

    @Override
    public List<TechId> listSampleIdsByContainerIds(Collection<TechId> containers) {
        List<Long> longIds = TechId.asLongs(containers);
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(SamplePE.class);
                criteria.setProjection((Projection)Projections.id());
                return criteria;
            }
        }, "container.id", longIds);
        if (operationLog.isDebugEnabled()) {
            operationLog.info(String.format("found %s sample components for given containers", results.size()));
        }
        return SampleDAO.transformNumbers2TechIdList(results);
    }

    @Override
    public List<TechId> listSampleIdsByExperimentIds(Collection<TechId> experiments) {
        List<Long> longIds = TechId.asLongs(experiments);
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(SamplePE.class);
                criteria.setProjection((Projection)Projections.id());
                return criteria;
            }
        }, "experimentInternal.id", longIds);
        if (operationLog.isDebugEnabled()) {
            operationLog.info(String.format("found %s samples for given experiments", results.size()));
        }
        return SampleDAO.transformNumbers2TechIdList(results);
    }

    @Override
    Logger getLogger() {
        return operationLog;
    }
}

