/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.db.SQLStateUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.exception.SampleUniqueCodeViolationException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.exception.SampleUniqueSubcodeViolationException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.dao.DataAccessException;

public class SampleDataAccessExceptionTranslator {
    private static final String CODE_CONSTRAINT_NAME = "samp_code_unique_check_uk";
    private static final String SUBCODE_CONSTRAINT_NAME = "samp_subcode_unique_check_uk";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile(".*constraint \"(.*)\".*=\\((.*)\\).*", 32);

    public static void translateAndThrow(DataAccessException exception) {
        if (SampleDataAccessExceptionTranslator.isUniqueCodeViolationException(exception)) {
            SampleDataAccessExceptionTranslator.throwUniqueCodeViolationException(exception);
        } else if (SampleDataAccessExceptionTranslator.isUniqueSubcodeViolationException(exception)) {
            SampleDataAccessExceptionTranslator.throwUniqueSubcodeViolationException(exception);
        } else {
            throw exception;
        }
    }

    public static boolean isUniqueCodeViolationException(DataAccessException exception) {
        UniqueViolationMessage message = UniqueViolationMessage.get(exception);
        return message != null && CODE_CONSTRAINT_NAME.equalsIgnoreCase(message.getConstraintName());
    }

    public static boolean isUniqueSubcodeViolationException(DataAccessException exception) {
        UniqueViolationMessage message = UniqueViolationMessage.get(exception);
        return message != null && SUBCODE_CONSTRAINT_NAME.equalsIgnoreCase(message.getConstraintName());
    }

    public static void throwUniqueCodeViolationException(DataAccessException exception) {
        UniqueViolationMessage message = UniqueViolationMessage.get(exception);
        if (message != null) {
            throw new SampleUniqueCodeViolationException(message.getSampleCode());
        }
    }

    public static void throwUniqueSubcodeViolationException(DataAccessException exception) {
        UniqueViolationMessage message = UniqueViolationMessage.get(exception);
        if (message != null) {
            throw new SampleUniqueSubcodeViolationException(message.getSampleCode());
        }
    }

    private static class UniqueViolationMessage {
        private String constraintName;
        private String columnValue;

        private UniqueViolationMessage() {
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public String getSampleCode() {
            String[] parts;
            if (this.columnValue != null && (parts = this.columnValue.split(",")) != null && parts.length > 0) {
                return parts[0];
            }
            return null;
        }

        public static final UniqueViolationMessage get(DataAccessException exception) {
            String sqlState;
            SQLException sqlException = SQLStateUtils.tryGetNextExceptionWithNonNullState(exception);
            if (sqlException != null && SQLStateUtils.isUniqueViolation(sqlState = sqlException.getSQLState()) && sqlException.getNextException() != null && sqlException.getNextException().getMessage() != null) {
                String message = sqlException.getNextException().getMessage();
                Matcher matcher = MESSAGE_PATTERN.matcher(message);
                if (matcher.find()) {
                    UniqueViolationMessage result = new UniqueViolationMessage();
                    result.constraintName = matcher.group(1);
                    result.columnValue = matcher.group(2);
                    return result;
                }
            }
            return null;
        }
    }
}

