/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.DefaultFullTextIndexer;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.HibernateSearchContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdater;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexer;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IIndexedEntityFinder;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexMode;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.PackageBasedIndexedEntityFinder;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.store.DirectoryProvider;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public final class FullTextIndexerRunnable
extends HibernateDaoSupport
implements Runnable {
    public static final String FULL_TEXT_INDEX_MARKER_FILENAME = ".MARKER_full_index";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FullTextIndexerRunnable.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, FullTextIndexerRunnable.class);
    private final HibernateSearchContext context;
    private final IFullTextIndexer fullTextIndexer;
    private final IFullTextIndexUpdater fullTextIndexUpdater;
    private final IIndexedEntityFinder indexedEntityFinder;

    public FullTextIndexerRunnable(SessionFactory sessionFactory, HibernateSearchContext context, IFullTextIndexUpdater fullTextIndexUpdater) {
        assert (context != null) : "Unspecified hibernate search context.";
        this.setSessionFactory(sessionFactory);
        this.context = context;
        this.fullTextIndexUpdater = fullTextIndexUpdater;
        this.fullTextIndexer = new DefaultFullTextIndexer(context.getBatchSize());
        this.indexedEntityFinder = new PackageBasedIndexedEntityFinder("ch.systemsx.cisd.openbis.generic.shared.dto");
        operationLog.info(String.format("Hibernate search context: %s.", context));
    }

    @Override
    public final void run() {
        IndexMode indexMode = this.context.getIndexMode();
        if (indexMode == IndexMode.NO_INDEX) {
            operationLog.debug(String.format("Skipping indexing process as  '%s' mode was configured.", new Object[]{indexMode}));
            return;
        }
        Set<Class<?>> indexedEntities = this.indexedEntityFinder.getIndexedEntities();
        if (indexedEntities.size() == 0) {
            operationLog.info(String.format("No entity annotated with '%s' has been found.", Indexed.class.getSimpleName()));
            return;
        }
        Class<?> currentEntity = null;
        try {
            IndexWriterConfig.setDefaultWriteLockTimeout((long)3000L);
            File indexBase = new File(this.context.getIndexBase());
            File markerFile = new File(indexBase, FULL_TEXT_INDEX_MARKER_FILENAME);
            Session session = this.getSession();
            this.writeLockRecovery(session, indexedEntities);
            if (indexMode == IndexMode.SKIP_IF_MARKER_FOUND && markerFile.exists()) {
                operationLog.debug(String.format("Skipping indexing process as marker file '%s' already exists.", markerFile.getAbsolutePath()));
                return;
            }
            try {
                this.fullTextIndexUpdater.clear();
                StopWatch stopWatch = new StopWatch();
                Iterator<Class<?>> iterator = indexedEntities.iterator();
                while (iterator.hasNext()) {
                    Class<?> indexedEntity;
                    currentEntity = indexedEntity = iterator.next();
                    stopWatch.reset();
                    stopWatch.start();
                    this.fullTextIndexer.doFullTextIndex(session, indexedEntity);
                    stopWatch.stop();
                    operationLog.info(String.format("Indexing entity '%s' took %s.", indexedEntity.getName(), stopWatch));
                }
                FileUtils.touch((File)markerFile);
                this.releaseSession(session);
            }
            catch (Throwable th) {
                notificationLog.error(String.format("A problem has occurred while indexing entity '%s'.", currentEntity), th);
            }
        }
        finally {
            this.fullTextIndexUpdater.start();
        }
    }

    private void writeLockRecovery(Session session, Set<Class<?>> indexedEntities) throws IOException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        SearchFactory searchFactory = fullTextSession.getSearchFactory();
        for (Class<?> indexedEntity : indexedEntities) {
            DirectoryProvider[] directoryProviders;
            DirectoryProvider[] directoryProviderArray = directoryProviders = searchFactory.getDirectoryProviders(indexedEntity);
            int n = directoryProviders.length;
            int n2 = 0;
            while (n2 < n) {
                DirectoryProvider provider = directoryProviderArray[n2];
                IndexWriter.unlock((Directory)provider.getDirectory());
                ++n2;
            }
        }
    }
}

