/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexMode;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public final class HibernateSearchContext
implements InitializingBean {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HibernateSearchContext.class);
    private IndexMode indexMode = IndexMode.SKIP_IF_MARKER_FOUND;
    private String indexBase = System.getProperty("java.io.tmpdir");
    private int batchSize = 1000;
    private int maxResults = 100000;

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        if (maxResults > 0) {
            this.maxResults = maxResults;
        }
    }

    public final String getIndexBase() {
        return this.indexBase;
    }

    public final void setIndexBase(String indexBase) {
        if (StringUtils.isNotBlank((String)indexBase)) {
            this.indexBase = indexBase;
        }
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(int batchSize) {
        this.batchSize = Math.max(0, batchSize);
    }

    public final IndexMode getIndexMode() {
        return this.indexMode;
    }

    public final void setIndexMode(IndexMode indexMode) {
        assert (indexMode != null) : "Unspecified index mode.";
        this.indexMode = indexMode;
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }

    public final void afterPropertiesSet() throws Exception {
        File searchIndexBase;
        if (this.getIndexMode() == IndexMode.INDEX_FROM_SCRATCH && (searchIndexBase = new File(this.getIndexBase())).exists()) {
            boolean deleted = FileUtilities.deleteRecursively(searchIndexBase, new Log4jSimpleLogger(operationLog, Level.DEBUG));
            operationLog.info(String.format("Index base '%s' %s.", searchIndexBase.getAbsolutePath(), deleted ? "has been successfully deleted" : "has NOT been deleted"));
        }
    }
}

