/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationSchedulerWithQueue;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdateScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexUpdateOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.DefaultBatchDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IBatchDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public final class DynamicPropertyEvaluationRunnable
extends HibernateDaoSupport
implements Runnable {
    private static final int BATCH_SIZE = 1000;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DynamicPropertyEvaluationRunnable.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DynamicPropertyEvaluationRunnable.class);
    private final IFullTextIndexUpdateScheduler fullTextIndexUpdateScheduler;
    private final IDynamicPropertyEvaluationSchedulerWithQueue evaluationQueue;
    private final IBatchDynamicPropertyEvaluator evaluator;

    public DynamicPropertyEvaluationRunnable(SessionFactory sessionFactory, IDAOFactory daoFactory, IFullTextIndexUpdateScheduler fullTextIndexUpdateScheduler, IDynamicPropertyEvaluationSchedulerWithQueue evaluationQueue, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.fullTextIndexUpdateScheduler = fullTextIndexUpdateScheduler;
        this.evaluationQueue = evaluationQueue;
        this.setSessionFactory(sessionFactory);
        this.evaluator = new DefaultBatchDynamicPropertyEvaluator(1000, daoFactory, dynamicPropertyCalculatorFactory, managedPropertyEvaluatorFactory);
    }

    @Override
    public final void run() {
        operationLog.info("Start dynamic properties evaluator queue.");
        try {
            while (true) {
                block21: {
                    IndexUpdateOperation indexUpdateOperation;
                    Collection<Long> ids;
                    DynamicPropertyEvaluationOperation operation = this.evaluationQueue.peekWait();
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info("Update: " + operation);
                    }
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start();
                    Session session = null;
                    Class<?> clazz = null;
                    Collection<Long> modifiedIds = null;
                    try {
                        try {
                            clazz = Class.forName(operation.getClassName());
                            session = this.getSession();
                            modifiedIds = operation.getIds() == null ? this.evaluator.doEvaluateProperties(session, clazz) : this.evaluator.doEvaluateProperties(session, clazz, new ArrayList<Long>(operation.getIds()));
                            stopWatch.stop();
                        }
                        catch (RuntimeException e) {
                            notificationLog.error("Error: " + operation + ".", e);
                            if (session != null) {
                                this.releaseSession(session);
                            }
                            if (operationLog.isInfoEnabled()) {
                                operationLog.info("Update of " + (modifiedIds == null ? "" : String.valueOf(modifiedIds.size()) + " ") + operation.getClassName() + "s took " + stopWatch);
                            }
                            if (clazz != null) {
                                Collection<Long> collection = ids = operation.getIds() == null ? modifiedIds : operation.getIds();
                                if (ids.size() > 0) {
                                    indexUpdateOperation = IndexUpdateOperation.reindex(clazz, new LinkedList<Long>(ids));
                                    this.fullTextIndexUpdateScheduler.scheduleUpdate(indexUpdateOperation);
                                }
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            this.releaseSession(session);
                        }
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info("Update of " + (modifiedIds == null ? "" : String.valueOf(modifiedIds.size()) + " ") + operation.getClassName() + "s took " + stopWatch);
                        }
                        if (clazz != null) {
                            Collection<Long> collection = ids = operation.getIds() == null ? modifiedIds : operation.getIds();
                            if (ids.size() > 0) {
                                indexUpdateOperation = IndexUpdateOperation.reindex(clazz, new LinkedList<Long>(ids));
                                this.fullTextIndexUpdateScheduler.scheduleUpdate(indexUpdateOperation);
                            }
                        }
                        throw throwable;
                    }
                    if (session != null) {
                        this.releaseSession(session);
                    }
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info("Update of " + (modifiedIds == null ? "" : String.valueOf(modifiedIds.size()) + " ") + operation.getClassName() + "s took " + stopWatch);
                    }
                    if (clazz != null) {
                        Collection<Long> collection = ids = operation.getIds() == null ? modifiedIds : operation.getIds();
                        if (ids.size() > 0) {
                            indexUpdateOperation = IndexUpdateOperation.reindex(clazz, new LinkedList<Long>(ids));
                            this.fullTextIndexUpdateScheduler.scheduleUpdate(indexUpdateOperation);
                        }
                    }
                }
                this.evaluationQueue.take();
            }
        }
        catch (Throwable th) {
            notificationLog.error("A problem has occurred while evaluating dynamic properties.", th);
            return;
        }
    }
}

