/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorIterator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityTypeRecord;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

public class EntityAdaptorRelationsLoader {
    private Long entityId;
    private IDynamicPropertyEvaluator evaluator;
    private Session session;

    public EntityAdaptorRelationsLoader(Long entityId, IDynamicPropertyEvaluator evaluator, Session session) {
        this.entityId = entityId;
        this.evaluator = evaluator;
        this.session = session;
    }

    public <T> Iterable<T> entitiesOfType(Class<?> entityClass, String entityTypeRegexp, IEntityTypesLoader entityTypesLoader, IEntityIdsOfTypesLoader entityIdsOfTypesLoader) {
        List<EntityTypeRecord> allTypes = entityTypesLoader.loadEntityTypes();
        LongOpenHashSet matchingTypeIds = new LongOpenHashSet();
        if (allTypes != null) {
            for (EntityTypeRecord type : allTypes) {
                if (!type.code.matches(entityTypeRegexp)) continue;
                matchingTypeIds.add((Object)type.id);
            }
        }
        if (matchingTypeIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> entityIds = entityIdsOfTypesLoader.loadEntityIdsOfTypes(this.entityId, (LongSet)matchingTypeIds);
        if (entityIds != null && entityIds.size() > 0) {
            Criteria criteria = this.session.createCriteria(entityClass);
            criteria.setFetchSize(10);
            criteria.add(Restrictions.in((String)"id", entityIds));
            ScrollableResults results = criteria.scroll(ScrollMode.FORWARD_ONLY);
            return new EntityAdaptorIterator(results, this.evaluator, this.session);
        }
        return Collections.emptyList();
    }

    public static interface IEntityIdsOfTypesLoader {
        public List<Long> loadEntityIdsOfTypes(Long var1, LongSet var2);
    }

    public static interface IEntityTypesLoader {
        public List<EntityTypeRecord> loadEntityTypes();
    }
}

