/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.AbstractEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorIterator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IExperimentAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.ISampleAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import org.apache.lucene.search.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;

public class ExperimentAdaptor
extends AbstractEntityAdaptor
implements IExperimentAdaptor,
INonAbstractEntityAdapter {
    private final ExperimentPE experimentPE;
    private final Session session;

    public ExperimentAdaptor(ExperimentPE experimentPE, IDynamicPropertyEvaluator evaluator, Session session) {
        super(experimentPE, evaluator);
        this.session = session;
        this.experimentPE = experimentPE;
    }

    public ExperimentPE experimentPE() {
        return this.experimentPE;
    }

    @Override
    public ExperimentPE entityPE() {
        return this.experimentPE();
    }

    @Override
    public Iterable<ISampleAdaptor> samples() {
        return this.samplesOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<ISampleAdaptor> samplesOfType(String typeRegexp) {
        Query typeConstraint = this.regexpConstraint(ENTITY_TYPE_CODE_FIELD, typeRegexp.toLowerCase());
        Query experimentCodeConstraint = this.constraint("experiment id", Long.toString(this.experimentPE.getId()));
        Query query = this.and(typeConstraint, experimentCodeConstraint);
        ScrollableResults results = this.execute(query, SamplePE.class, this.session);
        EntityAdaptorIterator<ISampleAdaptor> iterator = new EntityAdaptorIterator<ISampleAdaptor>(results, this.evaluator, this.session);
        this.getResources().add(iterator);
        return iterator;
    }

    @Override
    public Iterable<IDataAdaptor> dataSets() {
        return this.dataSetsOfType(ENTITY_TYPE_ANY_CODE_REGEXP);
    }

    @Override
    public Iterable<IDataAdaptor> dataSetsOfType(String typeRegexp) {
        Query typeConstraint = this.regexpConstraint(ENTITY_TYPE_CODE_FIELD, typeRegexp.toLowerCase());
        Query experimentCodeConstraint = this.constraint("experiment id", Long.toString(this.experimentPE.getId()));
        Query query = this.and(typeConstraint, experimentCodeConstraint);
        ScrollableResults results = this.execute(query, DataPE.class, this.session);
        EntityAdaptorIterator<IDataAdaptor> iterator = new EntityAdaptorIterator<IDataAdaptor>(results, this.evaluator, this.session);
        this.getResources().add(iterator);
        return iterator;
    }
}

