/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonEntityValidationCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorHotDeployPlugin;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.JythonEntityValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.api.IEntityValidator;
import ch.systemsx.cisd.openbis.generic.shared.IJythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.AbstractCommonPropertyBasedHotDeployPluginFactory;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;

public class EntityValidatorFactory
extends AbstractCommonPropertyBasedHotDeployPluginFactory<IEntityValidatorHotDeployPlugin>
implements IEntityValidatorFactory {
    private final IJythonEvaluatorPool jythonEvaluatorPool;

    public EntityValidatorFactory(String pluginDirectoryPath, IJythonEvaluatorPool jythonEvaluatorPool) {
        super(pluginDirectoryPath);
        this.jythonEvaluatorPool = jythonEvaluatorPool;
    }

    @Override
    public IEntityValidator createEntityValidator(EntityTypePE entityTypePE, JythonEntityValidationCalculator.IValidationRequestDelegate<INonAbstractEntityAdapter> validationRequestedDelegate) {
        ScriptPE scriptPE = entityTypePE.getValidationScript();
        if (scriptPE != null) {
            IEntityValidator validator = this.createEntityValidator(scriptPE.getPluginType(), scriptPE.getName(), scriptPE.getScript());
            validator.init(validationRequestedDelegate);
            return validator;
        }
        return null;
    }

    @Override
    public IEntityValidator createEntityValidator(PluginType pluginType, final String scriptName, String script) {
        switch (pluginType) {
            case JYTHON: {
                return new JythonEntityValidator(script, this.jythonEvaluatorPool);
            }
            case PREDEPLOYED: {
                IEntityValidator entityValidator = (IEntityValidator)this.tryGetPredeployedPluginByName(scriptName);
                if (entityValidator != null) {
                    return entityValidator;
                }
                return new IEntityValidator(){

                    @Override
                    public String validate(IEntityAdaptor entity, boolean isNew) {
                        return "Couldn't find plugin named '" + scriptName + "'.";
                    }

                    @Override
                    public void init(JythonEntityValidationCalculator.IValidationRequestDelegate<INonAbstractEntityAdapter> validationRequestedDelegate) {
                    }
                };
            }
        }
        return null;
    }

    @Override
    protected String getPluginDescription() {
        return "entity validation";
    }

    @Override
    protected Class<IEntityValidatorHotDeployPlugin> getPluginClass() {
        return IEntityValidatorHotDeployPlugin.class;
    }

    @Override
    protected ScriptType getScriptType() {
        return ScriptType.ENTITY_VALIDATION;
    }

    @Override
    protected String getDefaultPluginSubDirName() {
        return "entity-validation";
    }
}

