/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.event;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeleteDataSetEventBuilder {
    private EventPE event = new EventPE();

    public DeleteDataSetEventBuilder(DataPE dataSet, PersonPE registrator) {
        this(Collections.singletonList(dataSet), registrator);
    }

    public DeleteDataSetEventBuilder(List<DataPE> dataSets, PersonPE registrator) {
        this.event.setEventType(EventType.DELETION);
        this.event.setEntityType(EventPE.EntityType.DATASET);
        this.setDataSets(dataSets);
        this.setRegistrator(registrator);
    }

    private void setDataSets(List<DataPE> dataSets) {
        if (dataSets == null || dataSets.isEmpty()) {
            throw new IllegalArgumentException("Data sets cannot be null or empty");
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<DeletedDataSetLocation> locations = new ArrayList<DeletedDataSetLocation>();
        for (DataPE dataSet : dataSets) {
            identifiers.add(dataSet.getCode());
            DeletedDataSetLocation location = new DeletedDataSetLocation();
            location.setDatastoreCode(dataSet.getDataStore().getCode());
            if (dataSet.isExternalData()) {
                location.setShareId(dataSet.tryAsExternalData().getShareId());
                location.setLocation(dataSet.tryAsExternalData().getLocation());
            }
            locations.add(location);
        }
        this.event.setIdentifiers(identifiers);
        this.event.setDescription(DeletedDataSetLocation.format(locations));
    }

    private void setRegistrator(PersonPE registrator) {
        if (registrator == null) {
            throw new IllegalArgumentException("Registrator cannot be null");
        }
        this.event.setRegistrator(registrator);
    }

    public void setReason(String reason) {
        this.event.setReason(reason);
    }

    public EventPE getEvent() {
        return this.event;
    }
}

