/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.AbstractGenericSampleRegisterEditForm;
import java.util.List;
import java.util.Map;

public final class GenericSampleRegistrationForm
extends AbstractGenericSampleRegisterEditForm {
    public GenericSampleRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, SampleType sampleType, ActionContext actionContext) {
        super(viewContext, inputWidgetDescriptions, actionContext);
        this.setResetButtonVisible(true);
        this.sampleType = sampleType;
    }

    @Override
    protected void resetFieldsAfterSave() {
        this.codeField.reset();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
        this.updateDirtyCheckAfterSave();
    }

    @Override
    protected void initializeFormFields() {
        this.propertiesEditor.initWithoutProperties(this.sampleType.getAssignedPropertyTypes());
    }

    @Override
    protected void loadForm() {
        this.initGUI();
    }

    @Override
    protected void save() {
        String experimentIdentifier = this.experimentField != null && this.experimentField.tryToGetValue() != null ? this.experimentField.tryToGetValue().getIdentifier() : null;
        String containerOrNull = StringUtils.trimToNull(this.container.getValue());
        NewSample newSample = NewSample.createWithParents(this.createSampleIdentifier(), this.sampleType, containerOrNull, this.getParents());
        List<IEntityProperty> properties = this.extractProperties();
        newSample.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
        newSample.setAttachments(this.attachmentsManager.extractAttachments());
        newSample.setExperimentIdentifier(experimentIdentifier);
        newSample.setMetaprojectsOrNull(this.metaprojectArea.tryGetModifiedMetaprojects());
        ((IGenericClientServiceAsync)this.viewContext.getService()).registerSample(this.attachmentsSessionKey, newSample, this.enrichWithPostRegistration(new RegisterSampleCallback(this.viewContext)));
    }

    @Override
    protected boolean isAutoGenerateCode() {
        return this.sampleType.isAutoGeneratedCode();
    }

    public final class RegisterSampleCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Void> {
        public RegisterSampleCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(Void result) {
            String code = (String)GenericSampleRegistrationForm.this.codeField.getValue();
            Space selectedGroup = GenericSampleRegistrationForm.this.groupSelectionWidget.tryGetSelectedSpace();
            boolean shared = SpaceSelectionWidget.isSharedSpace(selectedGroup);
            if (shared) {
                return "Shared sample <b>" + code + "</b> successfully registered";
            }
            return "Sample <b>" + code + "</b> successfully registered in space <b>" + selectedGroup.getCode() + "</b>";
        }
    }
}

