/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class NewMaterialParserObjectFactory
extends AbstractParserObjectFactory<NewMaterial> {
    private final Map<String, PropertyType> typeCache = new HashMap<String, PropertyType>();

    public NewMaterialParserObjectFactory(IPropertyMapper propertyMapper) {
        super(NewMaterial.class, propertyMapper);
    }

    private final PropertyType createPropertyType(String propertyTypeCode) {
        if (!this.typeCache.containsKey(propertyTypeCode)) {
            PropertyType propertyType = new PropertyType();
            propertyType.setCode(propertyTypeCode);
            this.typeCache.put(propertyTypeCode, propertyType);
        }
        return this.typeCache.get(propertyTypeCode);
    }

    private final void setProperties(NewMaterial newMaterial, String[] lineTokens) {
        ArrayList<EntityProperty> properties = new ArrayList<EntityProperty>();
        for (String unmatchedProperty : this.getUnmatchedProperties()) {
            String propertyDefault;
            IPropertyModel propertyModel = this.tryGetPropertyModel(unmatchedProperty);
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel, propertyDefault = this.tryGetPropertyDefault(unmatchedProperty));
            if (StringUtils.isEmpty((String)propertyValue)) continue;
            EntityProperty property = new EntityProperty();
            property.setPropertyType(this.createPropertyType(unmatchedProperty));
            property.setValue(NewMaterialParserObjectFactory.isDeletionMark(propertyValue) ? null : propertyValue);
            properties.add(property);
        }
        newMaterial.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
    }

    @Override
    protected final boolean ignoreUnmatchedProperties() {
        return true;
    }

    @Override
    public final NewMaterial createObject(String[] lineTokens) throws ParserException {
        NewMaterial newMaterial = (NewMaterial)super.createObject(lineTokens);
        this.setProperties(newMaterial, lineTokens);
        return newMaterial;
    }
}

