/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.UserFailureExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ParameterValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientService;
import ch.systemsx.cisd.openbis.plugin.query.client.web.server.resultset.QueryExpressionProvider;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.IQueryUpdates;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.NewQuery;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="query-plugin-service")
public class QueryClientService
extends AbstractClientService
implements IQueryClientService {
    private static final String QUERY_EXECUTION_ERROR_MSG = "Problem occured during query execution.<br><br>Check that all provided parameter values are correct. If everything seems fine contact query registrator or instance admin about a possible bug in the query definition.";
    @Resource(name="query-plugin-server")
    private IQueryServer queryServer;

    public QueryClientService() {
    }

    @Private
    QueryClientService(IQueryServer queryServer, IRequestContextProvider requestContextProvider) {
        super(requestContextProvider);
        this.queryServer = queryServer;
    }

    @Override
    protected IServer getServer() {
        return this.queryServer;
    }

    @Override
    public int initDatabases() {
        String sessionToken = this.getSessionToken();
        return this.queryServer.initDatabases(sessionToken);
    }

    @Override
    public List<QueryDatabase> listQueryDatabases() {
        String sessionToken = this.getSessionToken();
        return this.queryServer.listQueryDatabases(sessionToken);
    }

    @Override
    public TableModelReference createQueryResultsReport(QueryDatabase database, String sqlQuery, QueryParameterBindings bindingsOrNull) {
        String sessionToken = this.getSessionToken();
        TableModel tableModel = this.queryServer.queryDatabase(sessionToken, database, sqlQuery, bindingsOrNull, false);
        return this.createTableModelReference(tableModel);
    }

    @Override
    public List<ParameterValue> listParameterValues(QueryDatabase database, String sqlQuery) {
        String sessionToken = this.getSessionToken();
        TableModel tableModel = this.queryServer.queryDatabase(sessionToken, database, sqlQuery, null, true);
        TreeSet<ParameterValue> valuesSet = new TreeSet<ParameterValue>();
        boolean withDescription = tableModel.getHeader().size() > 1;
        for (TableModelRow row : tableModel.getRows()) {
            String value = row.getValues().get(0).toString();
            String description = withDescription ? row.getValues().get(1).toString() : null;
            valuesSet.add(new ParameterValue(value, description));
        }
        return new ArrayList<ParameterValue>(valuesSet);
    }

    @Override
    public TableModelReference createQueryResultsReport(TechId query, QueryParameterBindings bindingsOrNull) {
        try {
            String sessionToken = this.getSessionToken();
            TableModel tableModel = this.queryServer.queryDatabase(sessionToken, query, bindingsOrNull);
            return this.createTableModelReference(tableModel);
        }
        catch (UserFailureException e) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Problem occured during query execution.<br><br>Check that all provided parameter values are correct. If everything seems fine contact query registrator or instance admin about a possible bug in the query definition. DETAILS: " + e.getMessage(), e);
            }
            throw UserFailureExceptionTranslator.translate(e, QUERY_EXECUTION_ERROR_MSG);
        }
    }

    private TableModelReference createTableModelReference(TableModel tableModel) {
        String resultSetKey = this.saveReportInCache(tableModel);
        return new TableModelReference(resultSetKey, tableModel.getHeader(), tableModel.tryGetMessage());
    }

    @Override
    public List<QueryExpression> listQueries(QueryType queryType, BasicEntityType entityTypeOrNull) {
        String sessionToken = this.getSessionToken();
        return this.queryServer.listQueries(sessionToken, queryType, entityTypeOrNull);
    }

    @Override
    public TypedTableResultSet<QueryExpression> listQueries(IResultSetConfig<String, TableModelRowWithObject<QueryExpression>> resultSetConfig) {
        return this.listEntities(new QueryExpressionProvider(this.queryServer, this.getSessionToken()), resultSetConfig);
    }

    @Override
    public String prepareExportQueries(TableExportCriteria<TableModelRowWithObject<QueryExpression>> criteria) {
        return this.prepareExportEntities(criteria);
    }

    @Override
    public void registerQuery(NewQuery query) {
        this.queryServer.registerQuery(this.getSessionToken(), query);
    }

    @Override
    public void deleteQueries(List<TechId> filterIds) {
        this.queryServer.deleteQueries(this.getSessionToken(), filterIds);
    }

    @Override
    public void updateQuery(IQueryUpdates queryUpdate) {
        this.queryServer.updateQuery(this.getSessionToken(), queryUpdate);
    }
}

