/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.DataSetGroupLoader;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.ExperimentGroupLoader;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IGroupLoader;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.IGroupLoaderFactory;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.resultfilter.SampleGroupLoader;

class GroupLoaderFactory
implements IGroupLoaderFactory {
    private final IDAOFactory factory;

    public GroupLoaderFactory(IDAOFactory factory) {
        this.factory = factory;
    }

    @Override
    public IGroupLoader create(EntityKind kind) {
        switch (kind) {
            case EXPERIMENT: {
                return new ExperimentGroupLoader(this.factory.getExperimentDAO());
            }
            case SAMPLE: {
                return new SampleGroupLoader(this.factory.getSampleDAO());
            }
            case DATA_SET: {
                return new DataSetGroupLoader(this.factory.getDataDAO());
            }
            case MATERIAL: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalArgumentException();
    }
}

