/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.ReaderWrapper;
import loci.formats.meta.MetadataStore;

public class DimensionSwapper
extends ReaderWrapper {
    private CoreMetadata[] core;
    private String[] outputOrder;

    public static DimensionSwapper makeDimensionSwapper(IFormatReader r) {
        if (r instanceof DimensionSwapper) {
            return (DimensionSwapper)r;
        }
        return new DimensionSwapper(r);
    }

    public DimensionSwapper() {
    }

    public DimensionSwapper(IFormatReader r) {
        super(r);
    }

    public void swapDimensions(String order) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (order == null) {
            throw new IllegalArgumentException("order is null");
        }
        String oldOrder = this.getDimensionOrder();
        if (order.equals(oldOrder)) {
            return;
        }
        if (order.length() != 5) {
            throw new IllegalArgumentException("order is unexpected length (" + order.length() + ")");
        }
        int newX = order.indexOf("X");
        int newY = order.indexOf("Y");
        int newZ = order.indexOf("Z");
        int newC = order.indexOf("C");
        int newT = order.indexOf("T");
        if (newX < 0) {
            throw new IllegalArgumentException("X does not appear");
        }
        if (newY < 0) {
            throw new IllegalArgumentException("Y does not appear");
        }
        if (newZ < 0) {
            throw new IllegalArgumentException("Z does not appear");
        }
        if (newC < 0) {
            throw new IllegalArgumentException("C does not appear");
        }
        if (newT < 0) {
            throw new IllegalArgumentException("T does not appear");
        }
        if (newX > 1) {
            throw new IllegalArgumentException("X in unexpected position (" + newX + ")");
        }
        if (newY > 1) {
            throw new IllegalArgumentException("Y in unexpected position (" + newY + ")");
        }
        int[] dims = new int[5];
        int oldX = oldOrder.indexOf("X");
        int oldY = oldOrder.indexOf("Y");
        int oldZ = oldOrder.indexOf("Z");
        int oldC = oldOrder.indexOf("C");
        int oldT = oldOrder.indexOf("T");
        if (oldC != newC && this.reader.getRGBChannelCount() > 1) {
            throw new IllegalArgumentException("Cannot swap C dimension when RGB channel count > 1");
        }
        dims[oldX] = this.getSizeX();
        dims[oldY] = this.getSizeY();
        dims[oldZ] = this.getSizeZ();
        dims[oldC] = this.getSizeC();
        dims[oldT] = this.getSizeT();
        int series = this.getCoreIndex();
        this.core[series].sizeX = dims[newX];
        this.core[series].sizeY = dims[newY];
        this.core[series].sizeZ = dims[newZ];
        this.core[series].sizeC = dims[newC];
        this.core[series].sizeT = dims[newT];
        if (this.outputOrder[series] == null) {
            this.outputOrder[series] = this.core[series].dimensionOrder;
        }
        this.core[series].dimensionOrder = order;
        if (oldC != newC) {
            this.core[series].cLengths = new int[]{this.getSizeC()};
            this.core[series].cTypes = new String[]{"Channel"};
        }
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
    }

    public void setOutputOrder(String outputOrder) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        this.outputOrder[this.getCoreIndex()] = outputOrder;
    }

    public String getInputOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core[this.getCoreIndex()].dimensionOrder;
    }

    @Override
    public int getSizeX() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core[this.getCoreIndex()].sizeX;
    }

    @Override
    public int getSizeY() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core[this.getCoreIndex()].sizeY;
    }

    @Override
    public int getSizeZ() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core[this.getCoreIndex()].sizeZ;
    }

    @Override
    public int getSizeC() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core[this.getCoreIndex()].sizeC;
    }

    @Override
    public int getSizeT() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core[this.getCoreIndex()].sizeT;
    }

    @Override
    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        int[] cLengths = this.core[this.getCoreIndex()].cLengths;
        return cLengths == null ? super.getChannelDimLengths() : cLengths;
    }

    @Override
    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String[] cTypes = this.core[this.getCoreIndex()].cTypes;
        return cTypes == null ? super.getChannelDimTypes() : cTypes;
    }

    @Override
    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        String outOrder = this.outputOrder[this.getCoreIndex()];
        if (outOrder != null) {
            return outOrder;
        }
        return this.getInputOrder();
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return super.openBytes(this.reorder(no));
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), x, y, w, h);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf, x, y, w, h);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return super.openThumbBytes(this.reorder(no));
    }

    @Override
    public int[] getZCTCoords(int no) {
        return FormatTools.getZCTCoords(this, no);
    }

    @Override
    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex(this, z, c, t);
    }

    @Override
    public CoreMetadata[] getCoreMetadata() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.core;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        String oldFile = this.getCurrentFile();
        super.setId(id);
        if (!id.equals(oldFile) || this.outputOrder == null || this.outputOrder.length != this.reader.getCoreMetadata().length) {
            this.outputOrder = new String[this.reader.getCoreMetadata().length];
            this.core = this.copyCoreMetadata(this.reader);
        }
    }

    protected int reorder(int no) {
        if (this.getInputOrder() == null) {
            return no;
        }
        return FormatTools.getReorderedIndex(this.getInputOrder(), this.getDimensionOrder(), this.getSizeZ(), this.getEffectiveSizeC(), this.getSizeT(), this.getImageCount(), no);
    }
}

