/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MDBService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;

public class APLReader
extends FormatReader {
    private static final String[] METADATA_SUFFIXES = new String[]{"apl", "tnb", "mtb"};
    private String[] tiffFiles;
    private String[] xmlFiles;
    private TiffParser[] parser;
    private IFDList[] ifds;
    private Vector<String> used;

    public APLReader() {
        super("Olympus APL", new String[]{"apl", "tnb", "mtb", "tif"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.datasetDescription = "One .apl file, one .mtb file, one .tnb file, and a directory containing one or more .tif files";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location file2;
        Location parent;
        if (APLReader.checkSuffix(name, METADATA_SUFFIXES)) {
            return true;
        }
        if (APLReader.checkSuffix(name, "tif") && open && (parent = (file2 = new Location(name).getAbsoluteFile()).getParentFile()) != null) {
            try {
                parent = parent.getParentFile();
                parent = parent.getParentFile();
            }
            catch (NullPointerException e) {
                return false;
            }
            Location aplFile = new Location(parent, parent.getName() + ".apl");
            return aplFile.exists();
        }
        return false;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        Location xmlFile;
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.addAll(this.used);
        if (this.getSeries() < this.xmlFiles.length && (xmlFile = new Location(this.xmlFiles[this.getSeries()])).exists() && !xmlFile.isDirectory()) {
            files.add(this.xmlFiles[this.getSeries()]);
        }
        if (!noPixels && this.getSeries() < this.tiffFiles.length && new Location(this.tiffFiles[this.getSeries()]).exists()) {
            files.add(this.tiffFiles[this.getSeries()]);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        IFD ifd = (IFD)this.ifds[this.getSeries()].get(no);
        return this.parser[this.getSeries()].getSamples(ifd, buf, x, y, w, h);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tiffFiles = null;
            this.xmlFiles = null;
            this.used = null;
            this.ifds = null;
            if (this.parser != null) {
                for (TiffParser p : this.parser) {
                    if (p == null) continue;
                    p.getStream().close();
                }
            }
            this.parser = null;
        }
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds[this.getSeries()].get(0)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds[this.getSeries()].get(0)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        LOGGER.debug("Initializing {}", (Object)id);
        if (!APLReader.checkSuffix(id, "mtb")) {
            if (APLReader.checkSuffix(id, METADATA_SUFFIXES)) {
                String mtbFile;
                int underscore;
                int separator = id.lastIndexOf(File.separator);
                if (separator < 0) {
                    separator = 0;
                }
                if ((underscore = id.lastIndexOf("_")) < separator || APLReader.checkSuffix(id, "apl")) {
                    underscore = id.lastIndexOf(".");
                }
                if (!new Location(mtbFile = id.substring(0, underscore) + "_d.mtb").exists()) {
                    throw new FormatException(".mtb file not found");
                }
                this.currentId = new Location(mtbFile).getAbsolutePath();
            } else {
                String[] list;
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                parent = parent.getParentFile();
                for (String f : list = parent.list(true)) {
                    if (!APLReader.checkSuffix(f, "mtb")) continue;
                    this.currentId = new Location(parent, f).getAbsolutePath();
                    break;
                }
                if (!APLReader.checkSuffix(this.currentId, "mtb")) {
                    throw new FormatException(".mtb file not found");
                }
            }
        }
        String mtb = new Location(this.currentId).getAbsolutePath();
        LOGGER.debug("Reading .mtb file '{}'", (Object)mtb);
        MDBService mdb = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            mdb = factory.getInstance(MDBService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("MDB Tools Java library not found", de);
        }
        Object[] columnNames = null;
        Vector<String[]> rows = null;
        try {
            mdb.initialize(mtb);
            rows = mdb.parseDatabase().get(0);
            Object[] tmpNames = columnNames = rows.get(0);
            columnNames = new String[tmpNames.length - 1];
            System.arraycopy(tmpNames, 1, columnNames, 0, columnNames.length);
        }
        finally {
            mdb.close();
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i2 = 1; i2 < rows.size(); ++i2) {
                String[] row = rows.get(i2);
                for (int q = 0; q < row.length; ++q) {
                    this.addGlobalMeta(columnNames[q] + " " + i2, row[q]);
                }
            }
        }
        this.used = new Vector();
        this.used.add(mtb);
        String tnb = mtb.substring(0, mtb.lastIndexOf("."));
        if (tnb.lastIndexOf("_") > tnb.lastIndexOf(File.separator)) {
            tnb = tnb.substring(0, tnb.lastIndexOf("_"));
        }
        this.used.add(tnb + "_1.tnb");
        this.used.add(tnb + ".apl");
        String idPath = new Location(id).getAbsolutePath();
        if (!this.used.contains(idPath) && APLReader.checkSuffix(idPath, METADATA_SUFFIXES)) {
            this.used.add(idPath);
        }
        int calibrationUnit = DataTools.indexOf(columnNames, "Calibration Unit");
        int colorChannels = DataTools.indexOf(columnNames, "Color Channels");
        int frames = DataTools.indexOf(columnNames, "Frames");
        int calibratedHeight = DataTools.indexOf(columnNames, "Height");
        int calibratedWidth = DataTools.indexOf(columnNames, "Width");
        int path = DataTools.indexOf(columnNames, "Image Path");
        int filename = DataTools.indexOf(columnNames, "File Name");
        int magnification = DataTools.indexOf(columnNames, "Magnification");
        int width = DataTools.indexOf(columnNames, "X-Resolution");
        int height = DataTools.indexOf(columnNames, "Y-Resolution");
        int imageName = DataTools.indexOf(columnNames, "Image Name");
        int zLayers = DataTools.indexOf(columnNames, "Z-Layers");
        String parentDirectory = mtb.substring(0, mtb.lastIndexOf(File.separator));
        LOGGER.debug("Searching {} for a directory with TIFFs", (Object)parentDirectory);
        Location dir = new Location(parentDirectory);
        String[] list = dir.list();
        String topDirectory = null;
        for (String f : list) {
            LOGGER.debug("  '{}'", (Object)f);
            Location file2 = new Location(dir, f);
            if (!file2.isDirectory() || f.indexOf("_DocumentFiles") <= 0) continue;
            topDirectory = file2.getAbsolutePath();
            LOGGER.debug("Found {}", (Object)topDirectory);
            break;
        }
        if (topDirectory == null) {
            throw new FormatException("Could not find a directory with TIFF files.");
        }
        Vector<Integer> seriesIndexes = new Vector<Integer>();
        for (int i3 = 1; i3 < rows.size(); ++i3) {
            String file3 = rows.get(i3)[filename].trim();
            if (file3.equals("") || !new Location(file3 = topDirectory + File.separator + file3).exists() || !APLReader.checkSuffix(file3, "tif")) continue;
            seriesIndexes.add(i3);
        }
        int seriesCount = seriesIndexes.size();
        this.core = new CoreMetadata[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            this.core[i] = new CoreMetadata();
        }
        this.tiffFiles = new String[seriesCount];
        this.xmlFiles = new String[seriesCount];
        this.parser = new TiffParser[seriesCount];
        this.ifds = new IFDList[seriesCount];
        for (i = 0; i < seriesCount; ++i) {
            int secondRow = (Integer)seriesIndexes.get(i);
            int firstRow = secondRow - 1;
            String[] row2 = rows.get(firstRow);
            String[] row3 = rows.get(secondRow);
            this.core[i].sizeT = this.parseDimension(row3[frames]);
            this.core[i].sizeZ = this.parseDimension(row3[zLayers]);
            this.core[i].sizeC = this.parseDimension(row3[colorChannels]);
            this.core[i].dimensionOrder = "XYCZT";
            if (this.core[i].sizeZ == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.core[i].sizeC == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.core[i].sizeT == 0) {
                this.core[i].sizeT = 1;
            }
            this.xmlFiles[i] = topDirectory + File.separator + row2[filename];
            this.tiffFiles[i] = topDirectory + File.separator + row3[filename];
            this.parser[i] = new TiffParser(this.tiffFiles[i]);
            this.parser[i].setDoCaching(false);
            this.ifds[i] = this.parser[i].getIFDs();
            for (IFD ifd : this.ifds[i]) {
                this.parser[i].fillInIFD(ifd);
            }
            for (IFD ifd : this.ifds[i]) {
                this.parser[i].fillInIFD(ifd);
            }
            IFD ifd = (IFD)this.ifds[i].get(0);
            PhotoInterp photo = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            this.core[i].sizeX = (int)ifd.getImageWidth();
            this.core[i].sizeY = (int)ifd.getImageLength();
            this.core[i].rgb = samples > 1 || photo == PhotoInterp.RGB;
            this.core[i].pixelType = ifd.getPixelType();
            this.core[i].littleEndian = ifd.isLittleEndian();
            this.core[i].indexed = photo == PhotoInterp.RGB_PALETTE && ifd.containsKey(320);
            this.core[i].imageCount = this.ifds[i].size();
            if (this.core[i].sizeZ * this.core[i].sizeT * (this.core[i].rgb ? 1 : this.core[i].sizeC) == this.core[i].imageCount) continue;
            this.core[i].sizeT = this.core[i].imageCount / (this.core[i].rgb ? 1 : this.core[i].sizeC);
            this.core[i].sizeZ = 1;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i4 = 0; i4 < seriesCount; ++i4) {
            String[] row = rows.get((Integer)seriesIndexes.get(i4));
            MetadataTools.setDefaultCreationDate(store, mtb, i4);
            store.setImageName(row[imageName].trim(), i4);
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            double realWidth = Double.parseDouble(row[calibratedWidth]);
            double realHeight = Double.parseDouble(row[calibratedHeight]);
            String units = row[calibrationUnit];
            double px = realWidth / (double)this.core[i4].sizeX;
            double py = realHeight / (double)this.core[i4].sizeY;
            if (units.equals("mm")) {
                px *= 1000.0;
                py *= 1000.0;
            }
            PositiveFloat physicalSizeX = FormatTools.getPhysicalSizeX(px);
            PositiveFloat physicalSizeY = FormatTools.getPhysicalSizeY(py);
            if (physicalSizeX != null) {
                store.setPixelsPhysicalSizeX(physicalSizeX, i4);
            }
            if (physicalSizeY == null) continue;
            store.setPixelsPhysicalSizeY(physicalSizeY, i4);
        }
    }

    private int parseDimension(String dim) {
        try {
            return Integer.parseInt(dim);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }
}

