/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class PGMReader
extends FormatReader {
    public static final char PGM_MAGIC_CHAR = 'P';
    private boolean rawBits;
    private long offset;

    public PGMReader() {
        super("Portable Gray Map", "pgm");
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.read() == 80 && Character.isDigit((char)stream.read());
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.offset);
        if (this.rawBits) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            ByteArrayHandle handle = new ByteArrayHandle();
            RandomAccessOutputStream out = new RandomAccessOutputStream(handle);
            out.order(this.isLittleEndian());
            while (this.in.getFilePointer() < this.in.length()) {
                String line = this.in.readLine().trim();
                line = line.replaceAll("[^0-9]", " ");
                StringTokenizer t = new StringTokenizer(line, " ");
                while (t.hasMoreTokens()) {
                    int q = Integer.parseInt(t.nextToken().trim());
                    if (this.getPixelType() == 3) {
                        out.writeShort(q);
                        continue;
                    }
                    out.writeByte(q);
                }
            }
            out.close();
            RandomAccessInputStream s = new RandomAccessInputStream(handle);
            s.seek(0L);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.rawBits = false;
            this.offset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        String magic = this.in.readLine().trim();
        boolean isBlackAndWhite = false;
        this.rawBits = magic.equals("P4") || magic.equals("P5") || magic.equals("P6");
        this.core[0].sizeC = magic.equals("P3") || magic.equals("P6") ? 3 : 1;
        isBlackAndWhite = magic.equals("P1") || magic.equals("P4");
        String line = this.readNextLine();
        line = line.replaceAll("[^0-9]", " ");
        int space = line.indexOf(" ");
        this.core[0].sizeX = Integer.parseInt(line.substring(0, space).trim());
        this.core[0].sizeY = Integer.parseInt(line.substring(space + 1).trim());
        if (!isBlackAndWhite) {
            int max = Integer.parseInt(this.readNextLine());
            this.core[0].pixelType = max > 255 ? 3 : 1;
        }
        this.offset = this.in.getFilePointer();
        this.addGlobalMeta("Black and white", isBlackAndWhite);
        this.core[0].rgb = this.getSizeC() == 3;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].littleEndian = true;
        this.core[0].interleaved = false;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private String readNextLine() throws IOException {
        String line = this.in.readLine().trim();
        while (line.startsWith("#") || line.length() == 0) {
            line = this.in.readLine().trim();
        }
        return line;
    }
}

