/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class PovrayReader
extends FormatReader {
    private static final int HEADER_SIZE = 6;

    public PovrayReader() {
        super("POV-Ray", "df3");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(6 + FormatTools.getPlaneSize(this) * no);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = false;
        this.in.order(this.isLittleEndian());
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        this.core[0].sizeZ = this.in.readShort();
        long fileLength = this.in.length() - 6L;
        int nBytes = (int)(fileLength / (long)(this.getSizeX() * this.getSizeY() * this.getSizeZ()));
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(nBytes, false, false);
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].rgb = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

