/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrairieMetadata {
    private final HashMap<Integer, Sequence> sequences = new HashMap();
    private Sequence firstSequence;
    private int cycleMin = Integer.MAX_VALUE;
    private int cycleMax = Integer.MIN_VALUE;
    private String date;
    private Double waitTime;
    private final HashSet<Integer> activeChannels = new HashSet();
    private final HashMap<String, String> config = new HashMap();

    public PrairieMetadata(Document xml, Document cfg) {
        if (xml != null) {
            this.parseXML(xml);
        }
        if (cfg != null) {
            this.parseCFG(cfg);
        }
    }

    public Double getWaitTime() {
        return this.waitTime;
    }

    public int[] getActiveChannels() {
        int[] result = new int[this.activeChannels.size()];
        int i = 0;
        for (int channelIndex : this.activeChannels) {
            result[i++] = channelIndex;
        }
        Arrays.sort(result);
        return result;
    }

    public boolean isInvertX() {
        return false;
    }

    public boolean isInvertY() {
        return this.b(this.getConfig("xYStageYPositionIncreasesBottomToTop"));
    }

    public Integer getBitDepth() {
        return this.i(this.getConfig("bitDepth"));
    }

    public Double getLaserPower() {
        return this.d(this.getConfig("laserPower_0"));
    }

    public String getConfig(String key) {
        return this.config.get(key);
    }

    public Map<String, String> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public String getDate() {
        return this.date;
    }

    public int getCycleMin() {
        return this.cycleMin;
    }

    public int getCycleMax() {
        return this.cycleMax;
    }

    public int getCycleCount() {
        return this.cycleMax - this.cycleMin + 1;
    }

    public Sequence getFirstSequence() {
        return this.firstSequence;
    }

    public Sequence getSequence(int cycle) {
        return this.sequences.get(cycle);
    }

    public ArrayList<Sequence> getSequences() {
        return this.valuesByKey(this.sequences);
    }

    public Frame getFrame(int cycle, int index) {
        Sequence sequence = this.getSequence(cycle);
        if (sequence == null) {
            return null;
        }
        return sequence.getFrame(index);
    }

    public PFile getFile(int cycle, int index, int channel) {
        Frame frame = this.getFrame(cycle, index);
        if (frame == null) {
            return null;
        }
        return frame.getFile(channel);
    }

    private void parseXML(Document doc) {
        Element pvScan = doc.getDocumentElement();
        this.checkElement(pvScan, "PVScan");
        this.date = pvScan.getAttribute("date");
        NodeList sequenceNodes = doc.getElementsByTagName("Sequence");
        for (int s = 0; s < sequenceNodes.getLength(); ++s) {
            int cycle;
            Element sequenceElement = this.el(sequenceNodes, s);
            if (sequenceElement == null) continue;
            Sequence sequence = new Sequence(sequenceElement);
            if (this.firstSequence == null) {
                this.firstSequence = sequence;
            }
            if ((cycle = sequence.getCycle()) < this.cycleMin) {
                this.cycleMin = cycle;
            }
            if (cycle > this.cycleMax) {
                this.cycleMax = cycle;
            }
            this.sequences.put(cycle, sequence);
        }
    }

    private void parseCFG(Document doc) {
        this.checkElement(doc.getDocumentElement(), "PVConfig");
        NodeList waitNodes = doc.getElementsByTagName("PVTSeriesElementWait");
        if (waitNodes.getLength() > 0) {
            Element waitElement = this.el(waitNodes, 0);
            this.waitTime = this.d(waitElement.getAttribute("waitTime"));
        }
        this.parseKeys(doc.getDocumentElement(), this.config);
        this.parseChannels();
    }

    private void parseKeys(Element el, HashMap<String, String> map) {
        NodeList keyNodes = el.getElementsByTagName("Key");
        for (int k = 0; k < keyNodes.getLength(); ++k) {
            Element keyElement = this.el(keyNodes, k);
            if (keyElement == null) continue;
            String key = keyElement.getAttribute("key");
            String value = keyElement.getAttribute("value");
            map.put(key, value);
        }
    }

    private void parseChannels() {
        for (String key : this.config.keySet()) {
            String value;
            if (!key.matches("channel_[0-9]+") || !this.b(value = this.config.get(key))) continue;
            int channelIndex = this.i(key.substring(8)) + 1;
            this.activeChannels.add(channelIndex);
        }
    }

    private void checkElement(Element el, String name) {
        if (!el.getNodeName().equals(name)) {
            throw new IllegalArgumentException("Not a " + name + " element");
        }
    }

    private Element el(NodeList nodes, int index) {
        Node node = nodes.item(index);
        if (!(node instanceof Element)) {
            return null;
        }
        return (Element)node;
    }

    private boolean b(String value) {
        return Boolean.parseBoolean(value);
    }

    private Double d(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Double(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private Integer i(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    private String token(String s, String regex, int i) {
        if (s == null) {
            return null;
        }
        String[] tokens = s.split(regex);
        return tokens.length > i ? tokens[i] : null;
    }

    private <K extends Comparable<? super K>, V> ArrayList<V> valuesByKey(Map<K, V> map) {
        ArrayList<K> keys = new ArrayList<K>(map.size());
        ArrayList<V> values = new ArrayList<V>(map.size());
        keys.addAll(map.keySet());
        Collections.sort(keys);
        for (Comparable key : keys) {
            values.add(map.get(key));
        }
        return values;
    }

    public class PFile {
        private Integer channel;
        private String channelName;
        private String filename;

        public PFile(Element fileElement) {
            this.parse(fileElement);
        }

        public void parse(Element fileElement) {
            PrairieMetadata.this.checkElement(fileElement, "File");
            this.channel = PrairieMetadata.this.i(fileElement.getAttribute("channel"));
            if (this.channel == null) {
                throw new IllegalArgumentException("File missing channel attribute");
            }
            this.channelName = fileElement.getAttribute("channelName");
            this.filename = fileElement.getAttribute("filename");
        }

        public int getChannel() {
            return this.channel;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public class Frame {
        private final HashMap<Integer, PFile> files = new HashMap();
        private final HashMap<String, String> values = new HashMap();
        private PFile firstFile;
        private Double relativeTime;
        private Double absoluteTime;
        private Integer index;

        public Frame(Element frameElement) {
            this.parse(frameElement);
        }

        public void parse(Element frameElement) {
            PrairieMetadata.this.checkElement(frameElement, "Frame");
            this.relativeTime = PrairieMetadata.this.d(frameElement.getAttribute("relativeTime"));
            this.absoluteTime = PrairieMetadata.this.d(frameElement.getAttribute("absoluteTime"));
            this.index = PrairieMetadata.this.i(frameElement.getAttribute("index"));
            if (this.index == null) {
                throw new IllegalArgumentException("Frame missing index attribute");
            }
            NodeList fileNodes = frameElement.getElementsByTagName("File");
            for (int f = 0; f < fileNodes.getLength(); ++f) {
                Element fileElement = PrairieMetadata.this.el(fileNodes, f);
                if (fileElement == null) continue;
                PFile file2 = new PFile(fileElement);
                if (this.firstFile == null) {
                    this.firstFile = file2;
                }
                int channel = file2.getChannel();
                this.files.put(channel, file2);
            }
            PrairieMetadata.this.parseKeys(frameElement, this.values);
        }

        public double getRelativeTime() {
            return this.relativeTime;
        }

        public double getAbsoluteTime() {
            return this.absoluteTime;
        }

        public int getIndex() {
            return this.index;
        }

        public PFile getFirstFile() {
            return this.firstFile;
        }

        public PFile getFile(int channel) {
            return this.files.get(channel);
        }

        public String getObjectiveLens() {
            return this.getValue("objectiveLens");
        }

        public String getObjectiveManufacturer() {
            return PrairieMetadata.this.token(this.getObjectiveLens(), " ", 0);
        }

        public Integer getMagnification() {
            return PrairieMetadata.this.i(PrairieMetadata.this.token(this.getObjectiveLens(), " ", 1));
        }

        public String getImmersion() {
            return PrairieMetadata.this.token(this.getObjectiveLens(), " ", 2);
        }

        public Double getObjectiveLensNA() {
            return PrairieMetadata.this.d(this.getValue("objectiveLensNA"));
        }

        public Integer getPixelsPerLine() {
            return PrairieMetadata.this.i(this.getValue("pixelsPerLine"));
        }

        public Integer getLinesPerFrame() {
            return PrairieMetadata.this.i(this.getValue("linesPerFrame"));
        }

        public Double getPositionX() {
            Double posX = PrairieMetadata.this.d(this.getValue("positionCurrent_XAxis"));
            return posX == null ? null : Double.valueOf(PrairieMetadata.this.isInvertX() ? -posX.doubleValue() : posX);
        }

        public Double getPositionY() {
            Double posY = PrairieMetadata.this.d(this.getValue("positionCurrent_YAxis"));
            return posY == null ? null : Double.valueOf(PrairieMetadata.this.isInvertY() ? -posY.doubleValue() : posY);
        }

        public Double getPositionZ() {
            return PrairieMetadata.this.d(this.getValue("positionCurrent_ZAxis"));
        }

        public Double getOpticalZoom() {
            return PrairieMetadata.this.d(this.getValue("opticalZoom"));
        }

        public Double getMicronsPerPixelX() {
            return PrairieMetadata.this.d(this.getValue("micronsPerPixel_XAxis"));
        }

        public Double getMicronsPerPixelY() {
            return PrairieMetadata.this.d(this.getValue("micronsPerPixel_YAxis"));
        }

        public Double getOffset(int c) {
            return PrairieMetadata.this.d(this.getValue("pmtOffset_" + c));
        }

        public Double getGain(int c) {
            return PrairieMetadata.this.d(this.getValue("pmtGain_" + c));
        }

        public String getImagingDevice() {
            return this.getValue("imagingDevice");
        }

        public String getValue(String key) {
            return this.values.get(key);
        }

        public Map<String, String> getValues() {
            return Collections.unmodifiableMap(this.values);
        }
    }

    public class Sequence {
        private final HashMap<Integer, Frame> frames = new HashMap();
        private Frame firstFrame;
        private int indexMin = Integer.MAX_VALUE;
        private int indexMax = Integer.MIN_VALUE;
        private String type;
        private Integer cycle;

        public Sequence(Element sequenceElement) {
            this.parse(sequenceElement);
        }

        public void parse(Element sequenceElement) {
            PrairieMetadata.this.checkElement(sequenceElement, "Sequence");
            this.type = sequenceElement.getAttribute("type");
            this.cycle = PrairieMetadata.this.i(sequenceElement.getAttribute("cycle"));
            if (this.cycle == null) {
                throw new IllegalArgumentException("Sequence missing cycle attribute");
            }
            NodeList frameNodes = sequenceElement.getElementsByTagName("Frame");
            for (int f = 0; f < frameNodes.getLength(); ++f) {
                int index;
                Element frameElement = PrairieMetadata.this.el(frameNodes, f);
                if (frameElement == null) continue;
                Frame frame = new Frame(frameElement);
                if (this.firstFrame == null) {
                    this.firstFrame = frame;
                }
                if ((index = frame.getIndex()) < this.indexMin) {
                    this.indexMin = index;
                }
                if (index > this.indexMax) {
                    this.indexMax = index;
                }
                this.frames.put(index, frame);
            }
        }

        public String getType() {
            return this.type;
        }

        public boolean isTimeSeries() {
            return "TSeries Timed Element".equals(this.type);
        }

        public int getCycle() {
            return this.cycle;
        }

        public int getIndexMin() {
            return this.indexMin;
        }

        public int getIndexMax() {
            return this.indexMax;
        }

        public int getIndexCount() {
            return this.indexMax - this.indexMin + 1;
        }

        public Frame getFirstFrame() {
            return this.firstFrame;
        }

        public Frame getFrame(int index) {
            return this.frames.get(index);
        }

        public PFile getFile(int index, int channel) {
            Frame frame = this.getFrame(index);
            if (frame == null) {
                return null;
            }
            return frame.getFile(channel);
        }
    }
}

