/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyramidTiffReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PyramidTiffReader.class);

    public PyramidTiffReader() {
        super("Pyramid TIFF", new String[]{"tif", "tiff"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.equalStrips = true;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setAssumeEqualStrips(this.equalStrips);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        if (software == null) {
            return false;
        }
        return software.indexOf("Faas") >= 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int index = this.getCoreIndex();
        this.tiffParser.getSamples((IFD)this.ifds.get(index), buf, x, y, w, h);
        return buf;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getCoreIndex())).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        this.core = new CoreMetadata[this.ifds.size()];
        for (int s = 0; s < this.core.length; ++s) {
            this.core[s] = new CoreMetadata();
            if (s == 0) {
                this.core[s].resolutionCount = this.core.length;
            }
            IFD ifd = (IFD)this.ifds.get(s);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            this.core[s].rgb = samples > 1 || p == PhotoInterp.RGB;
            long numTileRows = ifd.getTilesPerColumn() - 1L;
            long numTileCols = ifd.getTilesPerRow() - 1L;
            this.core[s].sizeX = (int)ifd.getImageWidth();
            this.core[s].sizeY = (int)ifd.getImageLength();
            this.core[s].sizeZ = 1;
            this.core[s].sizeT = 1;
            this.core[s].sizeC = this.core[s].rgb ? samples : 1;
            this.core[s].littleEndian = ifd.isLittleEndian();
            this.core[s].indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            this.core[s].imageCount = 1;
            this.core[s].pixelType = ifd.getPixelType();
            this.core[s].metadataComplete = true;
            this.core[s].interleaved = false;
            this.core[s].falseColor = false;
            this.core[s].dimensionOrder = "XYCZT";
            this.core[s].thumbnail = s > 0;
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }
}

