/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import loci.formats.ome.OMEXMLMetadata;
import ome.xml.DOMUtil;
import ome.xml.model.OMEModelObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractOMEXMLMetadata
implements OMEXMLMetadata {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA = "http://www.openmicroscopy.org/Schemas/OME/2012-06/ome.xsd";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractOMEXMLMetadata.class);
    protected OMEModelObject root;
    private Element imageCA;
    private DocumentBuilder builder;

    @Override
    public String dumpXML() {
        if (this.root == null) {
            this.root = (OMEModelObject)this.getRoot();
            if (this.root == null) {
                return null;
            }
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Document doc = this.createNewDocument();
            Element r = this.root.asXMLElement(doc);
            r.setAttribute("xmlns:xsi", XSI_NS);
            r.setAttribute("xsi:schemaLocation", "http://www.openmicroscopy.org/Schemas/OME/2012-06 http://www.openmicroscopy.org/Schemas/OME/2012-06/ome.xsd");
            doc.appendChild(r);
            DOMUtil.writeXML(os, doc);
            return os.toString("UTF-8");
        }
        catch (TransformerException exc) {
            LOGGER.warn("Failed to create OME-XML", exc);
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.warn("Failed to create OME-XML", exc);
        }
        return null;
    }

    @Override
    @Deprecated
    public String getUUID() {
        Element ome = this.getRootElement();
        return DOMUtil.getAttribute("UUID", ome);
    }

    @Override
    @Deprecated
    public void setRoot(Object root) {
    }

    @Override
    @Deprecated
    public Object getRoot() {
        return this.root;
    }

    @Override
    @Deprecated
    public void setUUID(String uuid) {
        Element ome = this.getRootElement();
        DOMUtil.setAttribute("UUID", uuid, ome);
    }

    @Deprecated
    protected Integer booleanToInteger(Boolean value) {
        return value == null ? null : new Integer(value != false ? 2 : 1);
    }

    @Deprecated
    protected Boolean integerToBoolean(Integer value) {
        return value == null ? null : new Boolean(value == 2);
    }

    @Deprecated
    protected Integer doubleToInteger(Double value) {
        return value == null ? null : new Integer(value.intValue());
    }

    @Deprecated
    protected Double integerToDouble(Integer value) {
        return value == null ? null : new Double(value.doubleValue());
    }

    private Document createNewDocument() {
        if (this.builder == null) {
            try {
                this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        return this.builder.newDocument();
    }

    @Deprecated
    private Element getRootElement() {
        return this.root.asXMLElement(this.createNewDocument());
    }
}

