/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.IJ;
import ij.gui.GenericDialog;
import java.io.File;
import java.math.BigInteger;
import loci.common.Location;
import loci.formats.FilePattern;
import loci.formats.FilePatternBlock;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;

public class FilePatternDialog
extends ImporterDialog {
    private FilePattern fp;
    private String originalID;
    private int[] paddingZeros;

    public FilePatternDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.options.isGroupFiles();
    }

    @Override
    protected GenericDialog constructDialog() {
        Location idLoc = new Location(this.options.getId());
        String id = FilePattern.findPattern(idLoc);
        if (id == null) {
            if (!this.options.isQuiet()) {
                IJ.showMessage((String)"Bio-Formats", (String)"Warning: Bio-Formats was unable to determine a grouping that\nincludes the file you chose. The most common reason for this\nsituation is that the folder contains extraneous files with\nsimilar names and numbers that confuse the detection algorithm.\n \nFor example, if you have multiple datasets in the same folder\nnamed series1_z*_c*.tif, series2_z*_c*.tif, etc., Bio-Formats\nmay try to group all such files into a single series.\n \nFor best results, put each image series's files in their own\nfolder, or type in a file pattern manually.\n");
            }
            id = idLoc.getAbsolutePath();
        }
        GenericDialog gd = new GenericDialog("Bio-Formats File Stitching");
        int len = id.length() + 1;
        if (len > 80) {
            len = 80;
        }
        this.originalID = id;
        this.fp = new FilePattern(id);
        String[] prefixes = this.fp.getPrefixes();
        int[] counts = this.fp.getCount();
        this.paddingZeros = new int[counts.length];
        String[][] elements = this.fp.getElements();
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = "Axis_" + (i + 1);
            gd.addStringField(prefix + "_number_of_images", "" + counts[i]);
            gd.addStringField(prefix + "_axis_first_image", "1");
            gd.addStringField(prefix + "_axis_increment", "1");
            gd.addMessage("");
            try {
                this.paddingZeros[i] = elements[i][0].length() - String.valueOf(Integer.parseInt(elements[i][0])).length();
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        gd.addStringField("File name contains:", "");
        gd.addStringField("Pattern: ", id, len);
        return gd;
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        String[] counts = new String[this.fp.getPrefixes().length];
        String[] firsts = new String[counts.length];
        String[] increments = new String[counts.length];
        int[] count = this.fp.getCount();
        boolean changedAxes = false;
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = gd.getNextString();
            firsts[i] = gd.getNextString();
            increments[i] = gd.getNextString();
            if (firsts[i].equals("1") && increments[i].equals("1") && Integer.parseInt(counts[i]) == count[i]) continue;
            changedAxes = true;
        }
        String contains = gd.getNextString();
        String id = gd.getNextString();
        if (!changedAxes) {
            if (contains.trim().length() > 0) {
                String dir = this.originalID.substring(0, this.originalID.lastIndexOf(File.separator) + 1);
                id = dir + ".*" + contains + ".*";
            }
        } else {
            String pattern = this.originalID.substring(0, this.originalID.lastIndexOf(File.separator) + 1);
            for (int i = 0; i < counts.length; ++i) {
                BigInteger first = new BigInteger(firsts[i]);
                BigInteger fileCount = new BigInteger(counts[i]);
                BigInteger increment = new BigInteger(increments[i]);
                FilePatternBlock block = new FilePatternBlock(this.fp.getBlock(i));
                first = first.add(block.getFirst()).subtract(BigInteger.ONE);
                fileCount = fileCount.multiply(increment).add(first);
                pattern = pattern + this.fp.getPrefix(i);
                pattern = pattern + "<";
                int firstPadding = this.paddingZeros[i] - first.toString().length() + 1;
                for (int zero = 0; zero < firstPadding; ++zero) {
                    pattern = pattern + "0";
                }
                pattern = pattern + first;
                pattern = pattern + "-";
                fileCount = fileCount.subtract(BigInteger.ONE);
                int lastPadding = this.paddingZeros[i] - fileCount.toString().length() + 1;
                for (int zero = 0; zero < lastPadding; ++zero) {
                    pattern = pattern + "0";
                }
                pattern = pattern + fileCount;
                pattern = pattern + ":";
                pattern = pattern + increment;
                pattern = pattern + ">";
            }
            id = pattern + this.fp.getSuffix();
        }
        this.options.setId(id);
        return true;
    }
}

