/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import java.awt.TextField;
import java.util.Vector;
import loci.common.Location;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;

public class IdDialog
extends ImporterDialog {
    private OpenDialog od;
    private String name;

    public IdDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        return this.options.getId() == null;
    }

    @Override
    protected GenericDialog constructDialog() {
        GenericDialog gd = null;
        if (this.options.isHTTP()) {
            gd = new GenericDialog("Bio-Formats URL");
            gd.addStringField("URL: ", "http://", 30);
        } else if (this.options.isOMERO()) {
            gd = new GenericDialog("OMERO Server Credentials");
            gd.addMessage("This plugin is not fully supported.\nPlease use the OMERO ImageJ/Fiji plugin from https://openmicroscopy.org/site/products/omero/downloads instead.");
            gd.addStringField("Server: ", "", 80);
            gd.addStringField("Port: ", "4064", 80);
            gd.addStringField("Username: ", "", 80);
            gd.addStringField("Password: ", "", 80);
            gd.addStringField("Group:    ", "default", 80);
            gd.addStringField("Image ID: ", "", 80);
            Vector v = gd.getStringFields();
            ((TextField)v.get(3)).setEchoChar('*');
        }
        return gd;
    }

    @Override
    protected boolean displayDialog(GenericDialog gd) {
        if (this.options.isLocal()) {
            String osVersion;
            if (this.options.isFirstTime() && IJ.isMacOSX() && !this.options.isQuiet() && ((osVersion = System.getProperty("os.version")) == null || osVersion.startsWith("10.4.") || osVersion.startsWith("10.3.") || osVersion.startsWith("10.2."))) {
                IJ.showMessage((String)"Bio-Formats", (String)"One-time warning: There is a bug in Java on Mac OS X with the native file chooser\nthat crashes ImageJ if you click on a file in CXD, IPW, OIB or ZVI format while in\ncolumn view mode. You can work around the problem in one of two ways:\n \n    1. Switch to list view (press Command+2)\n    2. Check \"Use JFileChooser to Open/Save\" under Edit>Options>Input/Output...");
            }
            String idLabel = this.options.getLabel("id");
            this.od = new OpenDialog(idLabel, this.options.getId());
            this.name = this.od.getFileName();
            if (this.name == null) {
                return false;
            }
        } else if (this.options.isHTTP() || this.options.isOMERO()) {
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        String id = null;
        if (this.options.isLocal()) {
            Location idLoc;
            String dir = this.od.getDirectory();
            if (dir != null || this.name == null) {
                id = dir + this.name;
            }
            if (!(idLoc = new Location(id)).exists() && !id.toLowerCase().endsWith(".fake")) {
                if (!this.options.isQuiet()) {
                    IJ.error((String)"Bio-Formats", (String)("The specified file (" + id + ") does not exist."));
                }
                return false;
            }
        } else if (this.options.isHTTP()) {
            id = gd.getNextString();
            if (id == null) {
                if (!this.options.isQuiet()) {
                    IJ.error((String)"Bio-Formats", (String)"No URL was specified.");
                }
                return false;
            }
        } else if (this.options.isOMERO()) {
            StringBuffer omero = new StringBuffer("omero:");
            omero.append("server=");
            omero.append(gd.getNextString());
            omero.append("\nport=");
            omero.append(gd.getNextString());
            omero.append("\nuser=");
            omero.append(gd.getNextString());
            omero.append("\npass=");
            omero.append(gd.getNextString());
            String group = gd.getNextString();
            Long groupID = null;
            try {
                groupID = new Long(group);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            omero.append("\ngroupName=");
            omero.append(group);
            if (groupID != null) {
                omero.append("\ngroupID=");
                omero.append(groupID);
            }
            omero.append("\niid=");
            omero.append(gd.getNextString());
            id = omero.toString();
        }
        this.options.setId(id);
        return true;
    }
}

