/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.shortcut;

import ij.IJ;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import loci.plugins.shortcut.ShortcutTransferHandler;
import loci.plugins.util.WindowTools;

public class ShortcutPanel
extends JPanel
implements ActionListener,
PlugIn {
    protected static final String OPENER_PLUGIN = "Bio-Formats Importer";
    protected static final String SHORTCUT_PLUGIN = "LOCI Plugins Shortcut Window";
    protected static final String NORMAL_MENU = "Plugins>LOCI";
    protected static final String HELP_MENU = "Help>About Plugins";
    protected static final int BORDER = 10;
    protected static int openerIndex;
    protected static String[] names;
    protected static String[] plugins;
    protected static String[] args;

    public ShortcutPanel() {
        int i;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setTransferHandler(new ShortcutTransferHandler(this));
        JButton[] b = new JButton[names.length];
        Dimension prefSize = new Dimension(-1, -1);
        Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (i = 0; i < names.length; ++i) {
            b[i] = new JButton(names[i]);
            Dimension d = b[i].getPreferredSize();
            if (d.width > prefSize.width) {
                prefSize.width = d.width;
            }
            if (d.height <= prefSize.height) continue;
            prefSize.height = d.height;
        }
        for (i = 0; i < b.length; ++i) {
            b[i].setPreferredSize(prefSize);
            b[i].setMaximumSize(maxSize);
            b[i].addActionListener(this);
            this.add(b[i]);
        }
    }

    public void open(String id) {
        String arg = args[openerIndex] + "open=[" + id + "] ";
        ShortcutPanel.runPlugIn(plugins[openerIndex], arg);
    }

    public static void runPlugIn(final String className, final String arg) {
        new Thread(){

            @Override
            public void run() {
                try {
                    IJ.runPlugIn((String)className, (String)arg);
                }
                catch (Throwable t) {
                    WindowTools.reportException(t);
                }
            }
        }.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton b = (JButton)e.getSource();
        String name = b.getText();
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            ShortcutPanel.runPlugIn(plugins[i], args[i]);
            break;
        }
    }

    public void run(String arg) {
        JFrame frame = new JFrame(SHORTCUT_PLUGIN);
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(new ShortcutPanel());
        frame.pack();
        WindowTools.placeWindow(frame);
        frame.setVisible(true);
    }

    static {
        int index = -1;
        ArrayList<String> vNames = new ArrayList<String>();
        ArrayList<String> vPlugins = new ArrayList<String>();
        ArrayList<String> vArgs = new ArrayList<String>();
        try {
            String line;
            URL url = ShortcutPanel.class.getResource("ShortcutPanel.class");
            String path = url.toString();
            path = path.substring(0, path.indexOf("!")) + "!/plugins.config";
            url = new URL(path);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                int quote4;
                int quote3;
                int quote2;
                int quote1;
                boolean normal = line.startsWith(NORMAL_MENU);
                boolean help = line.startsWith(HELP_MENU);
                if (!normal && !help || (quote1 = line.indexOf("\"")) < 0 || (quote2 = line.indexOf("\"", quote1 + 1)) < 0 || (quote3 = line.indexOf("\"", quote2 + 1)) < 0 || (quote4 = line.indexOf("\"", quote3 + 1)) < 0) continue;
                String name = line.substring(quote1 + 1, quote2);
                if (help) {
                    name = "About " + name.substring(0, name.length() - 3);
                }
                String plugin = line.substring(quote2 + 2, quote3 - 1).trim();
                String arg = line.substring(quote3 + 1, quote4);
                if (name.equals(OPENER_PLUGIN)) {
                    index = vNames.size();
                }
                if (name.equals(SHORTCUT_PLUGIN)) continue;
                vNames.add(name);
                vPlugins.add(plugin);
                vArgs.add(arg);
            }
            in.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        openerIndex = index;
        names = vNames.toArray(new String[0]);
        plugins = vPlugins.toArray(new String[0]);
        args = vArgs.toArray(new String[0]);
    }
}

