/*
 * Decompiled with CFR 0.152.
 */
package ome.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import ome.xml.DOMUtil;
import ome.xml.OMEXMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Deprecated
public final class OMEXMLFactory {
    public static final String LATEST_VERSION = "2012-06";
    protected static final String SKELETON = "<?xml version=\"1.0\"?>\n<OME xmlns=\"http://www.openmicroscopy.org/Schemas/OME/VERSION\" xmlns:Bin=\"http://www.openmicroscopy.org/Schemas/BinaryFile/VERSION\" xmlns:CA=\"http://www.openmicroscopy.org/Schemas/CA/VERSION\" xmlns:STD=\"http://www.openmicroscopy.org/Schemas/STD/VERSION\" xmlns:SPW=\"http://www.openmicroscopy.org/Schemas/SPW/VERSION\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.openmicroscopy.org/Schemas/OME/VERSION http://www.openmicroscopy.org/Schemas/OME/VERSION/ome.xsd http://www.openmicroscopy.org/Schemas/BinaryFile/VERSION http://www.openmicroscopy.org/Schemas/BinaryFile/VERSION/BinaryFile.xsd http://www.openmicroscopy.org/Schemas/CA/VERSION http://www.openmicroscopy.org/Schemas/CA/VERSION/CA.xsd http://www.openmicroscopy.org/Schemas/SPW/VERSION http://www.openmicroscopy.org/Schemas/SPW/VERSION/SPW.xsd http://www.openmicroscopy.org/Schemas/STD/VERSION http://www.openmicroscopy.org/Schemas/STD/VERSION/STD.xsd\"/>";
    protected static final String LEGACY_SKELETON = "<?xml version=\"1.0\"?>\n<OME xmlns=\"http://www.openmicroscopy.org/XMLschemas/OME/FC/ome.xsd\" xmlns:STD=\"http://www.openmicroscopy.org/XMLschemas/STD/RC2/STD.xsd\" xmlns:CA=\"http://www.openmicroscopy.org/XMLschemas/CA/RC1/CA.xsd\" xmlns:Bin=\"http://www.openmicroscopy.org/XMLschemas/BinaryFile/RC1/BinaryFile.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation = \"http://www.openmicroscopy.org/XMLschemas/OME/FC/ome.xsd http://www.openmicroscopy.org/XMLschemas/OME/FC/ome.xsd http://www.openmicroscopy.org/XMLschemas/STD/RC2/STD.xsd http://www.openmicroscopy.org/XMLschemas/STD/RC2/STD.xsd http://www.openmicroscopy.org/XMLschemas/CA/RC1/CA.xsd http://www.openmicroscopy.org/XMLschemas/CA/RC1/CA.xsd http://www.openmicroscopy.org/XMLschemas/CA/RC1/BinaryFile.xsd http://www.openmicroscopy.org/XMLschemas/CA/RC1/BinaryFile.xsd\"/>";

    private OMEXMLFactory() {
    }

    public static OMEXMLNode newOMENode() throws ParserConfigurationException, SAXException, IOException {
        return OMEXMLFactory.newOMENode(LATEST_VERSION);
    }

    public static OMEXMLNode newOMENode(String version) throws ParserConfigurationException, SAXException, IOException {
        String xml = null;
        if (version == null) {
            version = LATEST_VERSION;
        }
        xml = version.equals("2003-FC") ? LEGACY_SKELETON : SKELETON.replaceAll("VERSION", version);
        return OMEXMLFactory.newOMENodeFromSource(xml);
    }

    public static OMEXMLNode newOMENodeFromSource(File file2) throws ParserConfigurationException, SAXException, IOException {
        if (file2 == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        return OMEXMLFactory.newOMENodeFromSource(OMEXMLFactory.parseOME(file2));
    }

    public static OMEXMLNode newOMENodeFromSource(String xml) throws ParserConfigurationException, SAXException, IOException {
        if (xml == null) {
            throw new IllegalArgumentException("XML string must not be null");
        }
        return OMEXMLFactory.newOMENodeFromSource(OMEXMLFactory.parseOME(xml));
    }

    public static OMEXMLNode newOMENodeFromSource(Document doc) {
        String legacy = "http://www.openmicroscopy.org/XMLschemas/";
        String modern = "http://www.openmicroscopy.org/Schemas/OME/";
        Element el = doc.getDocumentElement();
        String version = null;
        String xmlns = DOMUtil.getAttribute("xmlns:ome", el);
        if (xmlns == null) {
            xmlns = DOMUtil.getAttribute("xmlns", el);
        }
        if (xmlns == null) {
            throw new IllegalArgumentException("Document does not contain an xmlns:ome or xmlns attribute");
        }
        if ((xmlns = xmlns.trim()).startsWith("http://www.openmicroscopy.org/XMLschemas/")) {
            version = "2003fc";
        } else if (xmlns.startsWith("http://www.openmicroscopy.org/Schemas/OME/")) {
            int len = "http://www.openmicroscopy.org/Schemas/OME/".length();
            int slash = "http://www.openmicroscopy.org/Schemas/OME/".indexOf("/", len);
            if (slash < 0) {
                slash = xmlns.length();
            }
            version = xmlns.substring(len, slash).replaceAll("\\W", "");
        } else {
            throw new IllegalArgumentException("Document has unknown schema: " + xmlns);
        }
        Object o = null;
        try {
            Class<?> c = Class.forName("ome.xml.r" + version + ".ome.OMENode");
            Constructor<?> con = c.getConstructor(Element.class);
            o = con.newInstance(el);
        }
        catch (ClassNotFoundException exc) {
        }
        catch (NoClassDefFoundError err) {
        }
        catch (NoSuchMethodException exc) {
        }
        catch (InstantiationException exc) {
        }
        catch (IllegalAccessException exc) {
        }
        catch (InvocationTargetException exc) {
            // empty catch block
        }
        if (o == null || !(o instanceof OMEXMLNode)) {
            throw new IllegalArgumentException("Unsupported schema version: " + version);
        }
        return o;
    }

    public static Document parseOME(File file2) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream is = new FileInputStream(file2);
        Document doc = OMEXMLFactory.parseOME(is);
        ((InputStream)is).close();
        return doc;
    }

    public static Document parseOME(String xml) throws ParserConfigurationException, SAXException, IOException {
        byte[] bytes = xml.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Document doc = OMEXMLFactory.parseOME(is);
        ((InputStream)is).close();
        return doc;
    }

    public static Document parseOME(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = DOMUtil.DOC_FACT.newDocumentBuilder();
        return db.parse(is);
    }
}

