/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum Binning implements Enumeration
{
    ONEXONE("1x1"),
    TWOXTWO("2x2"),
    FOURXFOUR("4x4"),
    EIGHTXEIGHT("8x8"),
    OTHER("Other");

    private final String value;

    private Binning(String value) {
        this.value = value;
    }

    public static Binning fromString(String value) throws EnumerationException {
        if ("1x1".equals(value)) {
            return ONEXONE;
        }
        if ("2x2".equals(value)) {
            return TWOXTWO;
        }
        if ("4x4".equals(value)) {
            return FOURXFOUR;
        }
        if ("8x8".equals(value)) {
            return EIGHTXEIGHT;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, Binning.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

