/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum Marker implements Enumeration
{
    ARROW("Arrow"),
    CIRCLE("Circle"),
    SQUARE("Square");

    private final String value;

    private Marker(String value) {
        this.value = value;
    }

    public static Marker fromString(String value) throws EnumerationException {
        if ("Arrow".equals(value)) {
            return ARROW;
        }
        if ("Circle".equals(value)) {
            return CIRCLE;
        }
        if ("Square".equals(value)) {
            return SQUARE;
        }
        String s = String.format("%s not a supported value of %s", value, Marker.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

