/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkPHYS;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunksToWrite {
    public static final int COPY_NONE = 0;
    public static final int COPY_PALETTE = 1;
    public static final int COPY_ALL_SAFE = 4;
    public static final int COPY_ALL = 8;
    public static final int COPY_PHYS = 16;
    public static final int COPY_TEXTUAL = 32;
    public static final int COPY_TRANSPARENCY = 64;
    public final ImageInfo imgInfo;
    private Map<String, PngChunk> chunks1 = new LinkedHashMap<String, PngChunk>();
    private List<PngChunk> chunks2 = new ArrayList<PngChunk>();
    private PngChunkPLTE palette = null;

    public static boolean maskMatch(int v, int mask) {
        return (v & mask) != 0;
    }

    public ChunksToWrite(ImageInfo info) {
        this.imgInfo = info;
    }

    public List<PngChunk> getPending() {
        ArrayList<PngChunk> li = new ArrayList<PngChunk>();
        for (PngChunk c : this.chunks1.values()) {
            if (c.getWriteStatus() > 1) continue;
            li.add(c);
        }
        if (this.palette != null && this.palette.getWriteStatus() <= 1) {
            li.add(this.palette);
        }
        for (PngChunk c : this.chunks2) {
            if (c.getWriteStatus() > 1) continue;
            li.add(c);
        }
        Collections.sort(li, new Comparator<PngChunk>(){

            @Override
            public int compare(PngChunk o1, PngChunk o2) {
                if (o1.getWriteStatus() != o2.getWriteStatus()) {
                    return o1.getWriteStatus() < o2.getWriteStatus() ? 1 : -1;
                }
                return ChunksToWrite.compareInt(o1.writeOrder(), o2.writeOrder());
            }
        });
        return li;
    }

    private static int compareInt(int a, int b) {
        return a < b ? -1 : 1;
    }

    public void setPHYS(long resx, long resy, int unit) {
        if (!this.chunks1.containsKey("pHYs")) {
            this.chunks1.put("pHYs", new PngChunkPHYS(this.imgInfo));
        }
        PngChunkPHYS chunk = (PngChunkPHYS)this.chunks1.get("pHYs");
        chunk.pixelsxUnitX = resx;
        chunk.pixelsxUnitY = resy;
        chunk.units = unit;
    }

    public void setPHYSdpi(double dpi) {
        long res = PngHelper.resDpiToMeters(dpi);
        this.setPHYS(res, res, 1);
    }

    public void copyPalette(PngChunkPLTE p) {
        this.palette = PngChunk.cloneChunk(p, this.imgInfo);
    }

    public void cloneAndAdd(PngChunk p, boolean overwrite) {
        if (p instanceof PngChunkPLTE) {
            if (this.palette != null && !overwrite) {
                return;
            }
            this.copyPalette((PngChunkPLTE)p);
        } else if (ChunkHelper.admitsMultiple(p.id)) {
            this.chunks2.add(PngChunk.cloneChunk(p, this.imgInfo));
        } else {
            if (this.chunks1.containsKey(p.id) && !overwrite) {
                return;
            }
            this.chunks1.put(p.id, PngChunk.cloneChunk(p, this.imgInfo));
        }
    }
}

