/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkICCP
extends PngChunk {
    private String profile;
    private byte[] compressedProfile;

    public PngChunkICCP(ImageInfo info) {
        super("iCCP", info);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = this.createEmptyChunk(this.profile.length() + this.compressedProfile.length + 2, true);
        System.arraycopy(ChunkHelper.toBytes(this.profile), 0, c.data, 0, this.profile.length());
        c.data[this.profile.length()] = 0;
        c.data[this.profile.length() + 1] = 0;
        System.arraycopy(this.compressedProfile, 0, c.data, this.profile.length() + 2, this.compressedProfile.length);
        return c;
    }

    public void parseFromChunk(ChunkRaw chunk) {
        int pos0 = ChunkHelper.posNullByte(chunk.data);
        this.profile = new String(chunk.data, 0, pos0, PngHelper.charsetLatin1);
        int comp = chunk.data[pos0 + 1] & 0xFF;
        if (comp != 0) {
            throw new RuntimeException("bad compression for ChunkTypeICCP");
        }
        int compdatasize = chunk.data.length - (pos0 + 2);
        this.compressedProfile = new byte[compdatasize];
        System.arraycopy(chunk.data, pos0 + 2, this.compressedProfile, 0, compdatasize);
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkICCP otherx = (PngChunkICCP)other;
        this.profile = otherx.profile;
        this.compressedProfile = otherx.compressedProfile;
    }
}

