/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.monitoring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class JMXMemoryMonitor {
    private static final double BYTES_PER_GIGABYTE = 1.073741824E9;
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, JMXMemoryMonitor.class);
    private static final Logger notifyLog = LogFactory.getLogger(LogCategory.NOTIFY, JMXMemoryMonitor.class);
    private final long logIntervalMillis;
    private final int memoryHighwaterMarkPercent;
    private long lastLoggedMillis;
    private boolean heapMemoryExhaustionNotificationSent;
    private boolean nonHeapMemoryExhaustionNotificationSent;

    public static final void startMonitor(long monitoringIntervalMillis, long logIntervalMillis, int memoryHighWatermarkPercent) {
        Timer timer = new Timer("memory monitor", true);
        JMXMemoryMonitor monitor = new JMXMemoryMonitor(logIntervalMillis, memoryHighWatermarkPercent);
        timer.schedule(monitor.getTimerTask(), 0L, monitoringIntervalMillis);
    }

    JMXMemoryMonitor(long logIntervallMillis, int memoryHighWatermarkPercent) {
        this.logIntervalMillis = logIntervallMillis;
        this.memoryHighwaterMarkPercent = memoryHighWatermarkPercent;
    }

    private int percentageUsed(MemoryUsage usage) {
        return (int)Math.ceil(100.0f * ((float)usage.getUsed() / (float)usage.getMax()));
    }

    TimerTask getTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                int percentageUsedNonHeap;
                long now = System.currentTimeMillis();
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                int percentageUsedHeap = JMXMemoryMonitor.this.percentageUsed(mbean.getHeapMemoryUsage());
                if (percentageUsedHeap > JMXMemoryMonitor.this.memoryHighwaterMarkPercent) {
                    if (!JMXMemoryMonitor.this.heapMemoryExhaustionNotificationSent) {
                        notifyLog.warn((Object)String.format("JVM exceeded high-water mark for heap memory: %.1f GB (%d%%)", (double)mbean.getHeapMemoryUsage().getUsed() / 1.073741824E9, percentageUsedHeap));
                        JMXMemoryMonitor.this.heapMemoryExhaustionNotificationSent = true;
                    }
                } else {
                    JMXMemoryMonitor.this.heapMemoryExhaustionNotificationSent = false;
                }
                if ((percentageUsedNonHeap = JMXMemoryMonitor.this.percentageUsed(mbean.getNonHeapMemoryUsage())) > JMXMemoryMonitor.this.memoryHighwaterMarkPercent) {
                    if (!JMXMemoryMonitor.this.nonHeapMemoryExhaustionNotificationSent) {
                        notifyLog.warn((Object)String.format("JVM exceeded high-water mark for non-heap memory: %.1f GB (%d%%)", (double)mbean.getNonHeapMemoryUsage().getUsed() / 1.073741824E9, percentageUsedNonHeap));
                        JMXMemoryMonitor.this.nonHeapMemoryExhaustionNotificationSent = true;
                    }
                } else {
                    JMXMemoryMonitor.this.nonHeapMemoryExhaustionNotificationSent = false;
                }
                long timeSinceLastLoggedMillis = now - JMXMemoryMonitor.this.lastLoggedMillis;
                if (JMXMemoryMonitor.this.logIntervalMillis >= 0L && timeSinceLastLoggedMillis > JMXMemoryMonitor.this.logIntervalMillis) {
                    machineLog.info((Object)String.format("Heap memory used: %.1f GB, non-heap memory used: %.1f GB. Number of active threads %s", (double)mbean.getHeapMemoryUsage().getUsed() / 1.073741824E9, (double)mbean.getNonHeapMemoryUsage().getUsed() / 1.073741824E9, Thread.activeCount()));
                    JMXMemoryMonitor.this.lastLoggedMillis = now;
                }
            }
        };
    }
}

