/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.dbmigration.DBUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DBScriptFormatter {
    private static final String COMMENT = "--";

    private static void printInitialComment(PrintWriter out, String sqlScript) {
        String[] stringArray = StringUtils.split((String)sqlScript, (char)'\n');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scriptLine = stringArray[n2];
            String trimmedScriptLine = scriptLine.trim();
            if (trimmedScriptLine.length() > 0 && !trimmedScriptLine.startsWith(COMMENT)) break;
            if (!trimmedScriptLine.substring(COMMENT.length()).trim().toUpperCase().startsWith("CREATING")) {
                out.println(trimmedScriptLine);
            }
            ++n2;
        }
    }

    private static List<String> getOrCreateList(Map<StatementClass, List<String>> map, StatementClass key) {
        List<String> list = map.get((Object)key);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(key, list);
        }
        return list;
    }

    private static boolean addIfAppropriate(String statement, StatementClass statementClass, Map<StatementClass, List<String>> map) {
        if (statementClass.matches(statement)) {
            DBScriptFormatter.getOrCreateList(map, statementClass).add(statementClass.process(statement));
            return true;
        }
        return false;
    }

    private static Map<StatementClass, List<String>> createStatementMap(List<String> sqlStatements) {
        HashMap<StatementClass, List<String>> map = new HashMap<StatementClass, List<String>>();
        block0: for (String sqlStatement : sqlStatements) {
            String upperCaseSqlStatement = sqlStatement.toUpperCase();
            StatementClass[] statementClassArray = StatementClass.values();
            int n = statementClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                StatementClass statementClass = statementClassArray[n2];
                if (DBScriptFormatter.addIfAppropriate(upperCaseSqlStatement, statementClass, map)) continue block0;
                ++n2;
            }
        }
        StatementClass[] statementClassArray = StatementClass.values();
        int n = statementClassArray.length;
        int n3 = 0;
        while (n3 < n) {
            StatementClass statementClass = statementClassArray[n3];
            Collections.sort(DBScriptFormatter.getOrCreateList(map, statementClass));
            ++n3;
        }
        return map;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Syntax: DBScriptFormatter <sql-script>");
            System.exit(1);
        }
        PrintWriter out = new PrintWriter(new FileOutputStream(new File(String.valueOf(args[0]) + ".formatted")));
        String sqlScript = FileUtilities.loadToString(new File(args[0]));
        List<String> sqlStatements = DBUtilities.splitSqlStatements(sqlScript);
        Map<StatementClass, List<String>> statementMap = DBScriptFormatter.createStatementMap(sqlStatements);
        DBScriptFormatter.printInitialComment(out, sqlScript);
        StatementClass[] statementClassArray = StatementClass.values();
        int n = statementClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatementClass statementClass = statementClassArray[n2];
            List<String> statementList = DBScriptFormatter.getOrCreateList(statementMap, statementClass);
            if (statementList.size() != 0) {
                out.println();
                out.print("-- ");
                out.println(statementClass.getComment());
                out.println();
                for (String statement : statementList) {
                    out.println(statement);
                }
            }
            ++n2;
        }
        out.close();
    }

    private static interface ILineMatcher {
        public boolean match(String var1);
    }

    private static interface ILineProcessor {
        public String process(String var1);
    }

    private static enum StatementClass {
        CREATE_DOMAIN("Creating domains", "CREATE DOMAIN "),
        CREATE_TABLE("Creating tables", "CREATE TABLE "),
        CREATE_SEQUENCE("Creating sequences", "CREATE SEQUENCE ", new ILineProcessor(){

            @Override
            public String process(String line) {
                return StringUtils.replace((String)line, (String)" NO MAXVALUE NO MINVALUE NO CYCLE", (String)"");
            }
        }),
        PRIMARY_KEY_CONSTRAINTS("Creating primary key constraints", new ILineMatcher(){

            @Override
            public boolean match(String line) {
                return Pattern.matches("ALTER TABLE .+ PRIMARY KEY.+", line);
            }
        }, null),
        UNIQUE_CONSTRAINTS("Creating unique constraints", new ILineMatcher(){

            @Override
            public boolean match(String line) {
                return Pattern.matches("ALTER TABLE .+ UNIQUE.+", line);
            }
        }, null),
        FOREIGN_KEY_CONSTRAINTS("Creating foreign key constraints", new ILineMatcher(){

            @Override
            public boolean match(String line) {
                return Pattern.matches("ALTER TABLE .+ FOREIGN KEY.+", line);
            }
        }, null),
        CHECK_CONSTRAINTS("Creating check constraints", new ILineMatcher(){

            @Override
            public boolean match(String line) {
                return Pattern.matches("ALTER TABLE .+ CHECK.+", line);
            }
        }, null),
        CREATE_INDEX("Creating indices", "CREATE INDEX "),
        MISC("Miscellaneous", new ILineMatcher(){

            @Override
            public boolean match(String line) {
                return true;
            }
        }, null);

        private ILineMatcher matcher;
        private String comment;
        private ILineProcessor processorOrNull;

        private StatementClass(String comment, String prefix) {
            this(comment, prefix, null);
        }

        private StatementClass(String comment, final String prefix, ILineProcessor processorOrNull) {
            this(comment, new ILineMatcher(){

                @Override
                public boolean match(String line) {
                    return line.startsWith(prefix);
                }
            }, processorOrNull);
        }

        private StatementClass(String comment, ILineMatcher matcher, ILineProcessor processorOrNull) {
            this.comment = comment;
            this.matcher = matcher;
            this.processorOrNull = processorOrNull;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean matches(String statement) {
            return this.matcher.match(statement);
        }

        public String process(String statement) {
            return this.processorOrNull == null ? statement : this.processorOrNull.process(statement);
        }
    }
}

