/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractDelegatingStorageProcessor
implements IStorageProcessorTransactional {
    protected static final String DELEGATE_PROCESSOR_CLASS_PROPERTY = "processor";
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractDelegatingStorageProcessor.class);
    protected final IStorageProcessorTransactional delegate;

    protected AbstractDelegatingStorageProcessor(Properties properties) {
        this(AbstractDelegatingStorageProcessor.createDelegateStorageProcessor(properties));
    }

    protected AbstractDelegatingStorageProcessor(IStorageProcessorTransactional delegateStorageProcessor) {
        this.delegate = delegateStorageProcessor;
    }

    static IStorageProcessorTransactional createDelegateStorageProcessor(Properties properties) {
        String delegateClass = PropertyUtils.getMandatoryProperty(properties, DELEGATE_PROCESSOR_CLASS_PROPERTY);
        ExtendedProperties p = ExtendedProperties.getSubset(properties, "processor.", true);
        return AbstractDelegatingStorageProcessor.createClass(IStorageProcessorTransactional.class, delegateClass, p);
    }

    private static final <T> T createClass(Class<T> superClazz, String className, Object ... argumentsOrNull) {
        try {
            return ClassUtils.create(superClazz, className, argumentsOrNull);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationFailureException(ex.getMessage());
        }
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters transactionParameters) {
        return this.delegate.createTransaction(transactionParameters);
    }

    @Override
    public StorageFormat getStorageFormat() {
        return this.delegate.getStorageFormat();
    }

    @Override
    public File getStoreRootDirectory() {
        return this.delegate.getStoreRootDirectory();
    }

    @Override
    public void setStoreRootDirectory(File storeRootDirectory) {
        this.delegate.setStoreRootDirectory(storeRootDirectory);
    }

    @Override
    public IStorageProcessorTransactional.UnstoreDataAction getDefaultUnstoreDataAction(Throwable exception) {
        return this.delegate.getDefaultUnstoreDataAction(exception);
    }
}

