/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class DataSetNameEntitiesProvider {
    private final char entitySeparatorCharacter;
    private final String[] entities;
    private final String errorMessagePrefix;

    public DataSetNameEntitiesProvider(File dataSetFile, char entitySeparatorCharacter, boolean stripExtension) {
        this(dataSetFile.getName(), entitySeparatorCharacter, stripExtension);
    }

    public DataSetNameEntitiesProvider(String dataSetName, char entitySeparatorCharacter, boolean stripExtension) {
        assert (dataSetName != null) : "Unspecified data set name.";
        this.entitySeparatorCharacter = entitySeparatorCharacter;
        String name = stripExtension ? FilenameUtils.getBaseName((String)dataSetName) : dataSetName;
        this.entities = StringUtils.split((String)name, (char)entitySeparatorCharacter);
        this.errorMessagePrefix = "Invalid data set name '" + dataSetName + "'. ";
    }

    public String getEntity(int index) {
        return this.getEntity(index, true);
    }

    String getEntity(int index, boolean throwException) {
        if (index >= this.entities.length) {
            return this.emptyStringOrThrowUserFailureException(index + 1, throwException);
        }
        int actualIndex = index;
        if (index < 0 && (actualIndex = this.entities.length + index) < 0) {
            return this.emptyStringOrThrowUserFailureException(-index, throwException);
        }
        return this.entities[actualIndex];
    }

    private String emptyStringOrThrowUserFailureException(int expectedNumberOfEntities, boolean throwException) {
        if (throwException) {
            throw new UserFailureException(String.valueOf(this.errorMessagePrefix) + "We need " + expectedNumberOfEntities + " entities, separated by '" + this.entitySeparatorCharacter + "', but got only " + this.entities.length + ".");
        }
        return "";
    }
}

