/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.api.v1;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.etlserver.ETLDaemon;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetServerPluginHolder;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

class DataSetTypeToRegistratorMapper {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetTypeToRegistratorMapper.class);
    private final ITopLevelDataSetRegistrator defaultHandler;
    private final HashMap<String, ITopLevelDataSetRegistrator> handlerMap;
    private final HashMap<String, ITopLevelDataSetRegistrator> dropboxToHandlerMap;
    private static final String DSS_RPC_SECTION_KEY = "dss-rpc";
    private static final String DEFAULT_THREAD_KEY = "put-default";
    private static final String PUT_SECTION_KEY = "put";

    protected DataSetTypeToRegistratorMapper(ITopLevelDataSetRegistrator plugin) {
        this.defaultHandler = plugin;
        this.handlerMap = new HashMap();
        this.dropboxToHandlerMap = new HashMap();
    }

    DataSetTypeToRegistratorMapper(Parameters params, IEncapsulatedOpenBISService openBISService, IMailClient mailClient, IDataSetValidator dataSetValidator) {
        DataSetTypeToTopLevelHandlerMapperInitializer initializer = new DataSetTypeToTopLevelHandlerMapperInitializer(params, openBISService, mailClient, dataSetValidator);
        initializer.initialize();
        this.defaultHandler = initializer.getDefaultHandler();
        this.dropboxToHandlerMap = initializer.getDropboxToHandlerMap();
        this.handlerMap = initializer.getHandlerMap(this.dropboxToHandlerMap);
    }

    public ITopLevelDataSetRegistrator getRegistratorForDropbox(String dropboxName) {
        if (dropboxName == null) {
            return this.defaultHandler;
        }
        ITopLevelDataSetRegistrator plugin = this.dropboxToHandlerMap.get(dropboxName);
        if (plugin == null) {
            operationLog.warn((Object)("Trying to drop dataset via rpc into dropbox " + dropboxName + ", but this dropbox was not configured for it so default dropbox will be used.\nIf that was not intended, then you need to add this line in your servers/datastore_server/etc/service.properties:\ndss-rpc.put." + dropboxName + " = " + dropboxName));
            return this.defaultHandler;
        }
        return plugin;
    }

    public ITopLevelDataSetRegistrator getRegistratorForType(String dataSetTypeOrNull) {
        if (dataSetTypeOrNull == null) {
            return this.defaultHandler;
        }
        ITopLevelDataSetRegistrator plugin = this.handlerMap.get(dataSetTypeOrNull);
        return plugin == null ? this.defaultHandler : plugin;
    }

    public void initializeStoreRootDirectory(File storeDirectory) {
        this.initializeStoreRootDirectory(storeDirectory, this.defaultHandler);
        for (ITopLevelDataSetRegistrator handler : this.handlerMap.values()) {
            this.initializeStoreRootDirectory(storeDirectory, handler);
        }
    }

    private void initializeStoreRootDirectory(File storeDirectory, ITopLevelDataSetRegistrator registrator) {
        if (registrator instanceof PutDataSetServerPluginHolder) {
            IETLServerPlugin plugin = ((PutDataSetServerPluginHolder)registrator).getPlugin();
            plugin.getStorageProcessor().setStoreRootDirectory(storeDirectory);
        }
    }

    private class DataSetTypeToTopLevelHandlerMapperInitializer {
        private final Parameters params;
        private final IEncapsulatedOpenBISService openBISService;
        private final IMailClient mailClient;
        private final IDataSetValidator dataSetValidator;
        private final HashMap<String, ThreadParameters> threadParamMap;
        private ExtendedProperties section;

        public DataSetTypeToTopLevelHandlerMapperInitializer(Parameters params, IEncapsulatedOpenBISService openBISService, IMailClient mailClient, IDataSetValidator dataSetValidator) {
            this.params = params;
            this.openBISService = openBISService;
            this.mailClient = mailClient;
            this.dataSetValidator = dataSetValidator;
            this.threadParamMap = new HashMap();
        }

        public void initialize() {
            this.initializeThreadMap();
            this.initializeSectionProperties();
        }

        public ITopLevelDataSetRegistrator getDefaultHandler() {
            ThreadParameters defaultThread;
            ThreadParameters[] threadParams = this.params.getThreads();
            ThreadParameters firstThread = threadParams[0];
            String defaultThreadName = this.section.getProperty(DataSetTypeToRegistratorMapper.DEFAULT_THREAD_KEY);
            ThreadParameters threadParameters = defaultThread = defaultThreadName != null ? this.threadParamMap.get(defaultThreadName) : null;
            if (defaultThread == null) {
                return ETLDaemon.createTopLevelDataSetRegistrator(this.params.getProperties(), firstThread, this.openBISService, this.mailClient, this.dataSetValidator, null, false, false, false, firstThread.tryGetPreRegistrationScript(), firstThread.tryGetPostRegistrationScript(), firstThread.tryGetValidationScripts(), PutDataSetServerPluginHolder.class);
            }
            return ETLDaemon.createTopLevelDataSetRegistrator(this.params.getProperties(), defaultThread, this.openBISService, this.mailClient, this.dataSetValidator, null, false, false, false, defaultThread.tryGetPreRegistrationScript(), defaultThread.tryGetPostRegistrationScript(), defaultThread.tryGetValidationScripts(), PutDataSetServerPluginHolder.class);
        }

        public HashMap<String, ITopLevelDataSetRegistrator> getDropboxToHandlerMap() {
            HashMap<String, ITopLevelDataSetRegistrator> map = new HashMap<String, ITopLevelDataSetRegistrator>();
            ExtendedProperties putSection = this.section.getSubset("put.", true);
            for (Object keyObject : putSection.keySet()) {
                String key = (String)keyObject;
                String threadName = ((Properties)putSection).getProperty(key);
                ThreadParameters threadParams = this.threadParamMap.get(threadName);
                if (threadParams == null) continue;
                ITopLevelDataSetRegistrator registrator = ETLDaemon.createTopLevelDataSetRegistrator(this.params.getProperties(), threadParams, this.openBISService, this.mailClient, this.dataSetValidator, null, false);
                map.put(threadName, registrator);
            }
            return map;
        }

        public HashMap<String, ITopLevelDataSetRegistrator> getHandlerMap(HashMap<String, ITopLevelDataSetRegistrator> dropboxToHandlerMap) {
            HashMap<String, ITopLevelDataSetRegistrator> map = new HashMap<String, ITopLevelDataSetRegistrator>();
            ExtendedProperties putSection = this.section.getSubset("put.", true);
            for (Object keyObject : putSection.keySet()) {
                String key = (String)keyObject;
                String threadName = ((Properties)putSection).getProperty(key);
                ThreadParameters threadParams = this.threadParamMap.get(threadName);
                if (threadParams == null) continue;
                ITopLevelDataSetRegistrator registrator = dropboxToHandlerMap.get(threadName);
                map.put(key.toUpperCase(), registrator);
            }
            return map;
        }

        private void initializeThreadMap() {
            ThreadParameters[] threadParams;
            ThreadParameters[] threadParametersArray = threadParams = this.params.getThreads();
            int n = threadParams.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadParameters threadParam = threadParametersArray[n2];
                this.threadParamMap.put(threadParam.getThreadName(), threadParam);
                ++n2;
            }
        }

        private void initializeSectionProperties() {
            this.section = ExtendedProperties.createWith(this.params.getProperties()).getSubset("dss-rpc.", true);
        }
    }
}

