/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.IAutoArchiverPolicy;
import ch.systemsx.cisd.etlserver.plugins.grouping.DatasetListWithTotal;
import ch.systemsx.cisd.etlserver.plugins.grouping.IGroupKeyProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public abstract class BaseGroupingPolicy
implements IAutoArchiverPolicy {
    public static final String MINIMAL_ARCHIVE_SIZE = "minimal-archive-size";
    public static final String MAXIMAL_ARCHIVE_SIZE = "maximal-archive-size";
    protected static final long DEFAULT_MINIMAL_ARCHIVE_SIZE = 0L;
    protected static final long DEFAULT_MAXIMAL_ARCHIVE_SIZE = Long.MAX_VALUE;
    protected final long minArchiveSize;
    protected final long maxArchiveSize;
    private IDataSetPathInfoProvider pathInfoProvider;

    public BaseGroupingPolicy(Properties properties) {
        this.minArchiveSize = PropertyUtils.getLong(properties, MINIMAL_ARCHIVE_SIZE, 0L);
        this.maxArchiveSize = PropertyUtils.getLong(properties, MAXIMAL_ARCHIVE_SIZE, Long.MAX_VALUE);
    }

    @Override
    public final List<AbstractExternalData> filter(List<AbstractExternalData> dataSets) {
        if (dataSets.isEmpty()) {
            return dataSets;
        }
        this.makeSureAllDataSetsWithSize(dataSets);
        return this.filterDataSetsWithSizes(dataSets);
    }

    protected abstract List<AbstractExternalData> filterDataSetsWithSizes(List<AbstractExternalData> var1);

    private void makeSureAllDataSetsWithSize(List<AbstractExternalData> dataSets) {
        for (AbstractExternalData dataSet : dataSets) {
            Long size = dataSet.getSize();
            if (size == null) {
                size = this.patchDataSetSize(dataSet);
            }
            if (size != null) continue;
            throw new EnvironmentFailureException("Some datasets have no size, and it cannot be calculated! E.g. " + dataSet.getCode());
        }
    }

    private Long patchDataSetSize(AbstractExternalData ds) {
        ISingleDataSetPathInfoProvider dsInfoProvider = this.getDatasetPathInfoProvider().tryGetSingleDataSetPathInfoProvider(ds.getCode());
        Long size = null;
        if (dsInfoProvider != null) {
            size = dsInfoProvider.getRootPathInfo().getSizeInBytes();
            ds.setSize(size);
        }
        return size;
    }

    private IDataSetPathInfoProvider getDatasetPathInfoProvider() {
        if (this.pathInfoProvider == null) {
            this.pathInfoProvider = ServiceProvider.getDataSetPathInfoProvider();
        }
        return this.pathInfoProvider;
    }

    protected Collection<DatasetListWithTotal> splitDataSetsInGroupsAccordingToCriteria(Iterable<AbstractExternalData> dataSets, IGroupKeyProvider provider) {
        HashMap<String, DatasetListWithTotal> result = new HashMap<String, DatasetListWithTotal>();
        for (AbstractExternalData ds : dataSets) {
            String key = provider.getGroupKey(ds);
            DatasetListWithTotal list = (DatasetListWithTotal)result.get(key);
            if (list == null) {
                list = new DatasetListWithTotal();
                result.put(key, list);
            }
            list.add(ds);
        }
        return result.values();
    }
}

