/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fasta.FastaUtilities;
import ch.systemsx.cisd.common.fasta.SequenceType;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.etlserver.plugins.BlastUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GenericFastaFileBuilder {
    private final File tempFolder;
    private final String baseName;
    private final Map<SequenceType, PrintWriter> writers = new HashMap<SequenceType, PrintWriter>();
    private FastaEntry currentFastaEntry;
    private EntryType currentEntryType;

    GenericFastaFileBuilder(File tempFolder, String baseName) {
        this.tempFolder = tempFolder;
        this.baseName = baseName;
    }

    String getBaseName() {
        return this.baseName;
    }

    void appendToSequence(String line) {
        if (this.currentFastaEntry == null) {
            throw new IllegalStateException(this.createErrorMessageForUndefinedEntry(line));
        }
        if (this.currentFastaEntry.getSeqType() == null) {
            this.currentFastaEntry.setSeqType(FastaUtilities.determineSequenceType(line));
            this.currentFastaEntry.appendSeq(line);
        } else if (this.currentEntryType == EntryType.FASTA) {
            this.currentFastaEntry.appendSeq(line);
        }
    }

    String createErrorMessageForUndefinedEntry(String line) {
        return "Unspecified entry";
    }

    void startEntry(EntryType entryType, String id, SequenceType sequenceTypeOrNull) {
        this.writeFastaEntry();
        this.currentFastaEntry = new FastaEntry(id);
        this.currentFastaEntry.setSeqType(sequenceTypeOrNull);
        this.currentEntryType = entryType;
    }

    void finish() {
        this.writeFastaEntry();
        for (PrintWriter printWriter : this.writers.values()) {
            printWriter.close();
        }
    }

    void cleanUp() {
        SequenceType[] values;
        SequenceType[] sequenceTypeArray = values = SequenceType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceType sequenceType = sequenceTypeArray[n2];
            File file = this.getTemporaryFastaFileOrNull(sequenceType);
            if (file != null) {
                FileUtilities.delete(file);
            }
            ++n2;
        }
    }

    File getTemporaryNuclFastaFileOrNull() {
        return this.getTemporaryFastaFileOrNull(SequenceType.NUCL);
    }

    File getTemporaryProtFastaFileOrNull() {
        return this.getTemporaryFastaFileOrNull(SequenceType.PROT);
    }

    File getTemporaryFastaFileOrNull(SequenceType seqType) {
        return this.writers.containsKey((Object)seqType) ? this.getFastaFile(seqType) : null;
    }

    void writeFastaEntry() {
        if (this.currentFastaEntry == null) {
            return;
        }
        SequenceType seqType = this.currentFastaEntry.getSeqType();
        List<String> lines = this.currentFastaEntry.getLines();
        if (seqType == null) {
            throw new IllegalStateException("Unknown type of the following FASTA entry: " + lines);
        }
        PrintWriter printer = this.getPrinter(seqType);
        for (String line : lines) {
            printer.println(line);
        }
        this.currentFastaEntry = null;
    }

    private PrintWriter getPrinter(SequenceType seqType) {
        PrintWriter printWriter = this.writers.get((Object)seqType);
        if (printWriter == null) {
            File fastaFile = this.getFastaFile(seqType);
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fastaFile)));
                this.writers.put(seqType, printWriter);
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("Couldn't create temporary FASTA file '" + fastaFile + "': " + ex.getMessage());
            }
        }
        return printWriter;
    }

    private File getFastaFile(SequenceType seqType) {
        return new File(this.tempFolder, String.valueOf(BlastUtilities.createDatabaseName(this.baseName, seqType)) + ".fa");
    }

    static enum EntryType {
        FASTA,
        FASTQ;

    }

    private static final class FastaEntry {
        private List<String> lines = new ArrayList<String>();
        private SequenceType seqType;

        FastaEntry(String id) {
            this.lines.add(">" + id);
        }

        void setSeqType(SequenceType seqType) {
            this.seqType = seqType;
        }

        SequenceType getSeqType() {
            return this.seqType;
        }

        void appendSeq(String seq) {
            this.lines.add(seq);
        }

        List<String> getLines() {
            return this.lines;
        }
    }
}

