/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins.grouping;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class DatasetListWithTotal
implements Iterable<AbstractExternalData>,
Comparable<DatasetListWithTotal> {
    private long dataSize = 0L;
    private List<AbstractExternalData> list = new ArrayList<AbstractExternalData>();

    public boolean add(AbstractExternalData e) {
        this.addSize(e.getSize());
        this.list.add(e);
        return true;
    }

    public long getCumulatedSize() {
        return this.dataSize;
    }

    private void addSize(long addon) {
        this.dataSize += addon;
    }

    public List<AbstractExternalData> getList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public int compareTo(DatasetListWithTotal arg0) {
        return Long.signum(this.dataSize - arg0.dataSize);
    }

    @Override
    public Iterator<AbstractExternalData> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    public void sort(Comparator<AbstractExternalData> comparator) {
        Collections.sort(this.list, comparator);
    }

    public String toString() {
        return CollectionUtils.collect(this.list, (Transformer)new Transformer<AbstractExternalData, String>(){

            public String transform(AbstractExternalData input) {
                return input.getCode();
            }
        }).toString();
    }
}

